/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.api.model;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.contentsquare.android.api.Currencies;
import com.contentsquare.android.common.features.logging.Logger;
import java.util.Locale;

public final class Transaction {
    @Nullable
    private String mId;
    private int mCurrency;
    @FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38)
    private float mValue;

    private Transaction(@NonNull TransactionBuilder transactionBuilder) {
        this.mId = transactionBuilder.mId;
        this.mCurrency = transactionBuilder.mCurrency;
        this.mValue = transactionBuilder.mValue;
    }

    @NonNull
    public static TransactionBuilder builder(@FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38) float f10, int n10) {
        return new TransactionBuilder(f10, n10);
    }

    @NonNull
    public static TransactionBuilder builder(@FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38) float f10, @NonNull String string) {
        return new TransactionBuilder(f10, string);
    }

    @Nullable
    public String getId() {
        return this.mId;
    }

    public int getCurrency() {
        return this.mCurrency;
    }

    public float getValue() {
        return this.mValue;
    }

    public static class TransactionBuilder {
        private static Logger sLogger = new Logger("TransactionBuilder");
        @Nullable
        private String mId;
        private int mCurrency;
        private float mValue;

        private TransactionBuilder(@FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38) float f10, int n10) {
            objectArray2.mValue = f10;
            objectArray2.mCurrency = Currencies.fromInteger(n10);
            if (objectArray2.mCurrency == -1) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n10;
                sLogger.i("Invalid currency code: \"%d\". Transaction currency is set to \"unknown(-1)\".", objectArray2);
            }
        }

        private TransactionBuilder(@FloatRange(from=1.401298464324817E-45, to=3.4028234663852886E38) float f10, @NonNull String string) {
            objectArray2.mValue = f10;
            objectArray2.mCurrency = Currencies.fromString(string.toUpperCase(Locale.ROOT));
            if (objectArray2.mCurrency == -1) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                sLogger.i("Invalid currency string: \"%s\". Transaction currency is set to \"unknown(-1)\".", objectArray2);
            }
        }

        public TransactionBuilder id(@NonNull String string) {
            this.mId = string;
            return this;
        }

        public Transaction build() {
            return new Transaction(this);
        }
    }
}

