/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.common.utils;

import android.app.Application;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.contentsquare.android.common.features.logging.Logger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\"\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\u0014\u0010\u000f\u001a\u00020\u0006*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\n\u0010\u0013\u001a\u00020\u0002*\u00020\u0014\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"csEndpoints", "", "", "getCsEndpoints", "()Ljava/util/List;", "drawOnTop", "", "Landroid/graphics/Bitmap;", "bmp", "posX", "", "posY", "isContentsquareUrl", "", "Ljava/net/URI;", "startServiceSafely", "Landroid/app/Application;", "service", "Landroid/content/Intent;", "toColorHex", "", "common_release"})
public final class ExtensionsKt {
    @NotNull
    private static final List<String> csEndpoints = CollectionsKt.listOf((Object[])new String[]{"contentsquare.net", "csqtrk.net"});

    public static final void drawOnTop(Bitmap bitmap, Bitmap bitmap2, float f10, float f11) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bmp");
        new Canvas(bitmap).drawBitmap(bitmap2, f10, f11, null);
    }

    public static final void startServiceSafely(Application application, Intent intent) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"service");
        try {
            application.startService(intent);
        }
        catch (IllegalStateException illegalStateException) {
            new Logger().i("Cannot open cs-in-app, please retry.", new Object[0]);
        }
    }

    @NotNull
    public static final List<String> getCsEndpoints() {
        return csEndpoints;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isContentsquareUrl(URI uRI) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<this>");
        Object object = csEndpoints;
        if (object instanceof Collection && object.isEmpty()) return false;
        object = object.iterator();
        do {
            if (!object.hasNext()) return false;
            String string = (String)object.next();
            String string2 = uRI.getHost();
            if (string2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"host");
                if (StringsKt.endsWith$default((String)string2, (String)string, (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final String toColorHex(int n10) {
        String string = String.format(Locale.ROOT, "#%08X", Arrays.copyOf(new Object[]{n10}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(locale, format, *args)");
        return string;
    }
}

