/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.common.utils;

import android.os.StatFs;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.contentsquare.android.common.features.logging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public class FileStorageUtil {
    public static final String DATA_CONTAINER = "cs";
    public static final int BUFFER_SIZE = 4096;
    public static final byte[] INVALID_FILE = new byte[0];
    private final Logger mLogger;

    public FileStorageUtil() {
        Logger logger;
        Logger logger2 = logger;
        logger = new Logger("FileStorageUtil");
        v1.mLogger = logger2;
    }

    private long getPhysicalSize(File fileArray, long l10) {
        long l11 = fileArray.length();
        if ((fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    l11 += this.getPhysicalSize(file, l10);
                    continue;
                }
                l11 = file.length() % l10 == 0L ? file.length() + l11 : (file.length() / l10 + 1L) * l10 + l11;
            }
        }
        return l11;
    }

    public boolean mkdirs(String string) {
        return this.getFile(string).mkdirs();
    }

    public void appendStringToFile(String string, String string2) {
        this.writeBytesToFile(string, string2.getBytes(Charset.forName("UTF-8")), true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeBytesToFile(String string, byte[] byArray, boolean bl) {
        Throwable throwable2222222;
        FileOutputStream fileOutputStream;
        block13: {
            Object[] objectArray = objectArray3.getFile(string);
            if (!objectArray3.touchFile((File)objectArray)) {
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = string;
                objectArray3.mLogger.e("Failed to open File: %s ", objectArray3);
                return;
            }
            fileOutputStream = null;
            objectArray3.mLogger.d("Writing to File: %s data %s", string, byArray);
            fileOutputStream = objectArray3.getFileOutputStream((File)objectArray, bl);
            {
                Object[] objectArray4;
                String string2;
                IOException iOException;
                Logger logger;
                FileOutputStream fileOutputStream2;
                catch (Throwable throwable2222222) {
                    break block13;
                }
                catch (IOException iOException2) {}
                {
                    fileOutputStream2 = fileOutputStream;
                    logger = objectArray3.mLogger;
                    iOException = iOException2;
                    string2 = "Data not written to file. Filename : %s";
                    objectArray4 = new Object[1];
                }
                objectArray = objectArray4;
                {
                    objectArray4[0] = string;
                    logger.e(iOException, string2, objectArray);
                }
                if (fileOutputStream2 == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException3) {
                    objectArray3.mLogger.e(iOException3, "Failed to close stream.", new Object[0]);
                    return;
                }
            }
            {
                fileOutputStream.write(byArray);
            }
            try {
                fileOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                objectArray3.mLogger.e(iOException, "Failed to close stream.", new Object[0]);
                return;
            }
        }
        if (fileOutputStream == null) throw throwable2222222;
        try {
            fileOutputStream.close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            objectArray3.mLogger.e(iOException, "Failed to close stream.", new Object[0]);
        }
        throw throwable2222222;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public List<String> readFileContentByLine(String string) {
        void var2_5;
        LinkedList<String> linkedList;
        File file;
        Object object = file;
        LinkedList<String> linkedList2 = linkedList;
        linkedList = new LinkedList<String>();
        if (!new File(string).exists()) return linkedList2;
        Object[] objectArray = objectArray4;
        Object[] objectArray2 = objectArray4;
        object = objectArray4.getFileInputStream((File)object);
        BufferedReader bufferedReader = objectArray.getBufferReader(objectArray2.getInputStreamReader((FileInputStream)object));
        while (true) {
            String string2 = bufferedReader.readLine();
            if (string2 == null) break;
            objectArray4.mLogger.d("File Data: %s", string2);
            linkedList2.add(string2);
        }
        bufferedReader.close();
        if (object == null) return linkedList2;
        ((FileInputStream)object).close();
        return linkedList2;
        catch (Throwable throwable) {
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (object == null) throw throwable3;
                    try {
                        ((FileInputStream)object).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throwable3.addSuppressed(throwable4);
                            throw throwable3;
                        }
                        catch (IOException iOException) {
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        Object[] objectArray3 = new Object[1];
        Object[] objectArray4 = objectArray3;
        objectArray3[0] = string;
        objectArray4.mLogger.e((Throwable)var2_5, "Failed while reading file : %s", objectArray4);
        return linkedList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public byte[] readFileContentAsBytes(String var1_1) {
        block26: {
            var2_5 = v0;
            var3_10 = null;
            var4_11 = null;
            if (!new File((String)var1_1).exists()) {
                return FileStorageUtil.INVALID_FILE;
            }
            try {
                v1 = this;
                var5_12 /* !! */  = new byte[4096];
            }
            catch (Throwable var1_3) {
                var6_13 = var3_10;
                break block26;
            }
            catch (IOException var2_8) {
                // empty catch block
                ** GOTO lbl-1000
            }
            var6_13 = v2;
            {
                v2 = new ByteArrayOutputStream();
            }
            try {
                var4_11 = v1.getFileInputStream(var2_5);
lbl20:
                // 2 sources

                while ((var2_6 = var4_11.read(var5_12 /* !! */ )) != -1) {
                    ** GOTO lbl-1000
                }
                ** GOTO lbl30
            }
            catch (Throwable var1_2) {
                break block26;
            }
            catch (IOException var2_7) {
                var3_10 = var6_13;
                ** GOTO lbl-1000
            }
lbl-1000:
            // 1 sources

            {
                var6_13.write(var5_12 /* !! */ , 0, var2_6);
                ** GOTO lbl20
lbl30:
                // 1 sources

                v3 = var6_13;
                v4 = v3;
                var1_1 = v3.toByteArray();
            }
            try {
                v4.close();
            }
            catch (IOException v5) {
                this.mLogger.w(v5, "Failed while closing : ByteArrayOutputStream", new Object[0]);
            }
            try {
                var4_11.close();
                return var1_1;
            }
            catch (IOException v6) {
                this.mLogger.w(v6, "Failed while closing : InputStream", new Object[0]);
            }
            return var1_1;
lbl-1000:
            // 2 sources

            {
                v7 = var3_10;
                v8 = this.mLogger;
                v9 = var2_9;
                var2_9 = "Failed while reading file : %s";
                v10 = new Object[1];
            }
            var5_12 /* !! */  = (byte[])v10;
            {
                v10[0] = var1_1;
                v8.e((Throwable)v9, var2_9, (Object[])var5_12 /* !! */ );
                var1_1 = FileStorageUtil.INVALID_FILE;
            }
            if (v7 != null) {
                try {
                    var3_10.close();
                }
                catch (IOException v11) {
                    this.mLogger.w(v11, "Failed while closing : ByteArrayOutputStream", new Object[0]);
                }
            }
            if (var4_11 == null) return var1_1;
            try {
                var4_11.close();
                return var1_1;
            }
            catch (IOException v12) {
                this.mLogger.w(v12, "Failed while closing : InputStream", new Object[0]);
            }
            return var1_1;
        }
        if (var6_13 != null) {
            try {
                var6_13.close();
            }
            catch (IOException v13) {
                this.mLogger.w(v13, "Failed while closing : ByteArrayOutputStream", new Object[0]);
            }
        }
        if (var4_11 == null) throw var1_4;
        try {
            var4_11.close();
            throw var1_4;
        }
        catch (IOException v14) {
            this.mLogger.w(v14, "Failed while closing : InputStream", new Object[0]);
        }
        throw var1_4;
    }

    public boolean isFolderWritable(String string) {
        return ((File)(this = ((FileStorageUtil)this).getFile(string))).isDirectory() && ((File)this).canRead() && ((File)this).canWrite();
    }

    @Nullable
    public String[] listFolder(String string) {
        if (((File)(this = ((FileStorageUtil)this).getFile(string))).isDirectory() && ((File)this).canRead()) {
            return ((File)this).list();
        }
        return null;
    }

    public boolean deleteFileOrFolder(String string) {
        return this.getFile(string).delete();
    }

    public boolean deleteRecursive(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            int n10 = fileArray.length;
            for (int i10 = 0; i10 < n10; ++i10) {
                this.deleteRecursive(fileArray[i10]);
            }
        }
        return file.delete();
    }

    public File getFile(String string) {
        return new File(string);
    }

    public boolean touchFile(File file) {
        if (file.exists()) {
            return true;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            this.mLogger.e(iOException, "Failed to create File. exiting... ", new Object[0]);
            return false;
        }
    }

    public long getPhysicalSize(String string) {
        FileStorageUtil fileStorageUtil = this;
        long l10 = this.getStatFs(string).getBlockSizeLong();
        return fileStorageUtil.getPhysicalSize(fileStorageUtil.getFile(string), l10);
    }

    @VisibleForTesting
    public StatFs getStatFs(String string) {
        return new StatFs(string);
    }

    @VisibleForTesting
    public FileOutputStream getFileOutputStream(File file, boolean bl) {
        return new FileOutputStream(file, bl);
    }

    @VisibleForTesting
    public FileInputStream getFileInputStream(File file) {
        return new FileInputStream(file);
    }

    @VisibleForTesting
    public InputStreamReader getInputStreamReader(FileInputStream fileInputStream) {
        return new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
    }

    @VisibleForTesting
    public BufferedReader getBufferReader(InputStreamReader inputStreamReader) {
        return new BufferedReader(inputStreamReader);
    }
}

