/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.internal.network.processors;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/contentsquare/android/error/analysis/internal/network/processors/UrlMasker;", "", "()V", "urlMaskingPatterns", "", "", "getUrlMaskingPatterns", "()Ljava/util/List;", "setUrlMaskingPatterns", "(Ljava/util/List;)V", "anonymizeTemplateParam", "param", "generateSubstitutions", "pattern", "maskUrl", "url", "maskWithPattern", "Companion", "library_release"})
public final class UrlMasker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex TEMPLATE_MATCHER = new Regex("/:\\w*");
    @NotNull
    private List<String> urlMaskingPatterns = CollectionsKt.emptyList();

    private final String maskWithPattern(String string, String string2) {
        List<String> list = ((UrlMasker)((Object)list)).generateSubstitutions(string);
        string = TEMPLATE_MATCHER.replace((CharSequence)string, "/([^/?]+)");
        if ((string = Regex.find$default((Regex)new Regex(string), (CharSequence)string2, (int)0, (int)2, null)) == null) {
            return null;
        }
        int n10 = 0;
        for (Object object : CollectionsKt.reversed((Iterable)CollectionsKt.drop((Iterable)string.getGroups(), (int)1))) {
            int n11 = n10 + 1;
            if (n10 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object object2 = (MatchGroup)object;
            object = (String)CollectionsKt.getOrNull((List)list, (int)n10);
            if (object != null && object2 != null) {
                object2 = ((Object)StringsKt.replaceRange((CharSequence)string2, (int)object2.getRange().getFirst(), (int)(object2.getRange().getLast() + 1), object)).toString();
                string2 = object2;
            }
            n10 = n11;
        }
        return string2;
    }

    private final List<String> generateSubstitutions(String iterator) {
        ArrayList<String> arrayList;
        iterator = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)TEMPLATE_MATCHER, (CharSequence)((Object)iterator), (int)0, (int)2, null), (Function1)a.a));
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(this.anonymizeTemplateParam((String)iterator.next()));
        }
        return CollectionsKt.reversed(arrayList2);
    }

    private final String anonymizeTemplateParam(String string) {
        String string2 = StringsKt.drop((String)string, (int)2);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
        return "CS_ANONYMIZED_" + string3;
    }

    @NotNull
    public final List<String> getUrlMaskingPatterns() {
        return this.urlMaskingPatterns;
    }

    public final void setUrlMaskingPatterns(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.urlMaskingPatterns = list;
    }

    @NotNull
    public final String maskUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"url");
        Iterator iterator = CollectionsKt.sortedWith(this.urlMaskingPatterns, new Comparator(){

            public final int compare(T t10, T t11) {
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((String)t11).length()), (Comparable)Integer.valueOf(((String)t10).length()));
            }
        }).iterator();
        while (iterator.hasNext()) {
            String string2 = this.maskWithPattern((String)iterator.next(), string);
            if (string2 == null) continue;
            return string2;
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/contentsquare/android/error/analysis/internal/network/processors/UrlMasker$Companion;", "", "()V", "TEMPLATE_MATCHER", "Lkotlin/text/Regex;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

