/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.expression;

import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;

public class Between
extends FieldExpression {
    private FieldValue from;
    private FieldValue to;
    private Every every;

    public Between(FieldConstraints constraints, FieldValue from, FieldValue to) {
        this(constraints, from, to, new IntegerFieldValue(1));
    }

    public Between(FieldConstraints constraints, FieldValue from, FieldValue to, IntegerFieldValue every) {
        super(constraints);
        this.from = this.validate(from);
        this.to = this.validate(to);
        this.every = new Every(this.getConstraints(), every);
        this.validate();
    }

    public Between(Between between) {
        this(between.getConstraints(), between.getFrom(), between.getTo(), between.getEvery().getTime());
    }

    public FieldValue getFrom() {
        return this.from;
    }

    public FieldValue getTo() {
        return this.to;
    }

    public Every getEvery() {
        return this.every;
    }

    private void validate() {
        if (this.from instanceof IntegerFieldValue && this.to instanceof IntegerFieldValue) {
            int toValue;
            int fromValue = ((IntegerFieldValue)this.from).getValue();
            if (fromValue >= (toValue = ((IntegerFieldValue)this.to).getValue().intValue())) {
                throw new IllegalArgumentException("Bad range defined! Defined range should satisfy from <= to, but was [%s, %s]");
            }
            if (this.every.getTime().getValue() > toValue - fromValue) {
                throw new IllegalArgumentException("Every x time cannot exceed range length");
            }
        }
        this.validateSpecialCharValue(this.from);
        this.validateSpecialCharValue(this.to);
    }

    private void validateSpecialCharValue(FieldValue fieldValue) {
        if (fieldValue instanceof SpecialCharFieldValue && !SpecialChar.L.equals(fieldValue.getValue())) {
            throw new IllegalArgumentException(String.format("%s value not supported in ranges", fieldValue));
        }
    }

    @Override
    public String asString() {
        return String.format("%s-%s%s", this.from, this.to, this.every.asString());
    }
}

