/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDataSource;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbRowSetMetaData;
import dm.jdbc.internal.AbstractRowSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.RowSetWarning;

public class DmdbJdbcRowSet
extends AbstractRowSet
implements JdbcRowSet {
    private DmdbResultSet m_resultSet;
    private DmdbConnection m_connection;
    private DmdbCallableStatement m_callableStmt;
    private boolean m_Closed;
    private static boolean m_driverManagerInitialized;
    private static final long serialVersionUID = 1L;

    public DmdbJdbcRowSet(DmdbConnection conn) {
        this.initialize(conn);
    }

    public DmdbJdbcRowSet() {
        this.initialize(null);
    }

    private void initialize(DmdbConnection conn) {
        this.m_connection = conn;
        m_driverManagerInitialized = false;
        this.m_Closed = false;
    }

    private void preparedConn() throws SQLException {
        if (this.m_connection != null && !this.m_connection.do_isClosed()) {
            return;
        }
        if (this.getDataSourceName() != null) {
            try {
                Properties localProperties = System.getProperties();
                InitialContext initialcontext = new InitialContext(localProperties);
                DmdbDataSource datasource = (DmdbDataSource)initialcontext.lookup(this.getDataSourceName());
                if (this.m_userName != null) {
                    datasource.setUser(this.m_userName);
                }
                if (this.m_password != null) {
                    datasource.setPassword(this.m_password);
                }
                this.m_connection = (DmdbConnection)datasource.getConnection();
            }
            catch (NamingException namingexception) {
                DBError.throwException("Unable to connect through the DataSource\n", namingexception);
            }
        } else if (!m_driverManagerInitialized) {
            try {
                Class.forName("dm.jdbc.driver.DmDriver");
                this.m_connection = (DmdbConnection)DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
            }
            catch (ClassNotFoundException e2) {
                DBError.throwRuntimeException("Can not load Driver class " + DmDriver.class.getName(), e2);
            }
            m_driverManagerInitialized = true;
        } else {
            this.m_connection = (DmdbConnection)DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        this.m_connection.do_setTransactionIsolation(this.getTransactionIsolation());
        this.m_connection.do_setReadOnly(super.isReadOnly());
        this.m_connection.do_setTypeMap(this.getTypeMap());
    }

    private void preparedStmt(boolean reset) throws SQLException {
        if (this.m_callableStmt != null && !this.m_callableStmt.do_isClosed() && !reset) {
            return;
        }
        if (this.m_callableStmt != null) {
            try {
                this.m_callableStmt.do_close();
            }
            catch (Exception exception) {}
            this.m_callableStmt = null;
        }
        this.preparedConn();
        this.m_callableStmt = this.m_connection.do_prepareCall(this.getCommand(), this.getType(), this.getConcurrency());
        this.m_callableStmt.do_setFetchSize(this.getFetchSize());
        this.m_callableStmt.do_setFetchDirection(this.getFetchDirection());
        this.m_callableStmt.do_setMaxFieldSize(this.getMaxFieldSize());
        this.m_callableStmt.do_setMaxRows(this.getMaxRows());
        this.m_callableStmt.do_setQueryTimeout(this.getQueryTimeout());
        this.m_callableStmt.do_setEscapeProcessing(this.getEscapeProcessing());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.m_callableStmt.do_setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.m_callableStmt.do_setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.m_callableStmt.do_setBoolean(parameterIndex, x2);
    }

    @Override
    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.m_callableStmt.do_setByte(parameterIndex, x2);
    }

    @Override
    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.m_callableStmt.do_setShort(parameterIndex, x2);
    }

    @Override
    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.m_callableStmt.do_setInt(parameterIndex, x2);
    }

    @Override
    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.m_callableStmt.do_setLong(parameterIndex, x2);
    }

    @Override
    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.m_callableStmt.do_setFloat(parameterIndex, x2);
    }

    @Override
    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.m_callableStmt.do_setDouble(parameterIndex, x2);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        this.m_callableStmt.do_setBigDecimal(parameterIndex, x2);
    }

    @Override
    public void setString(int parameterIndex, String x2) throws SQLException {
        this.m_callableStmt.do_setString(parameterIndex, x2);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        this.m_callableStmt.do_setBytes(parameterIndex, x2);
    }

    @Override
    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.m_callableStmt.do_setDate(parameterIndex, x2);
    }

    @Override
    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.m_callableStmt.do_setTime(parameterIndex, x2);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.m_callableStmt.do_setTimestamp(parameterIndex, x2);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.m_callableStmt.do_setAsciiStream(parameterIndex, x2, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.m_callableStmt.do_setBinaryStream(parameterIndex, x2, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.m_callableStmt.do_setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        this.m_callableStmt.do_setObject(parameterIndex, x2, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.m_callableStmt.do_setObject(parameterIndex, x2, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x2) throws SQLException {
        this.m_callableStmt.do_setObject(parameterIndex, x2);
    }

    @Override
    public void setRef(int i2, Ref x2) throws SQLException {
        this.m_callableStmt.do_setRef(i2, x2);
    }

    @Override
    public void setBlob(int i2, Blob x2) throws SQLException {
        this.m_callableStmt.do_setBlob(i2, x2);
    }

    @Override
    public void setClob(int i2, Clob x2) throws SQLException {
        this.m_callableStmt.do_setClob(i2, x2);
    }

    @Override
    public void setArray(int i2, Array x2) throws SQLException {
        this.m_callableStmt.do_setArray(i2, x2);
    }

    @Override
    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.m_callableStmt.do_setDate(parameterIndex, x2, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.m_callableStmt.do_setTime(parameterIndex, x2, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.m_callableStmt.do_setTimestamp(parameterIndex, x2, cal);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.m_callableStmt.do_clearParameters();
    }

    @Override
    public void execute() throws SQLException {
        this.preparedStmt(false);
        this.m_resultSet = this.m_callableStmt.do_executeQuery();
    }

    @Override
    public void setCommand(String cmd) throws SQLException {
        super.setCommand(cmd);
        this.preparedStmt(true);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        boolean flag = this.m_resultSet.do_next();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_Closed) {
            return;
        }
        if (this.m_resultSet != null) {
            try {
                this.m_resultSet.do_close();
            }
            catch (Exception exception) {}
            this.m_resultSet = null;
        }
        if (this.m_callableStmt != null) {
            try {
                this.m_callableStmt.do_close();
            }
            catch (Exception exception) {}
            this.m_callableStmt = null;
        }
        if (this.m_connection != null && !this.m_connection.do_isClosed()) {
            this.m_connection.do_commit();
            try {
                this.m_connection.do_close();
            }
            catch (Exception exception) {}
            this.m_connection = null;
        }
        this.m_Closed = true;
        this.notifyRowSetChanged();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_resultSet.do_wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.m_resultSet.do_getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.m_resultSet.do_getString(columnName);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.m_resultSet.do_getBoolean(columnName);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.m_resultSet.do_getByte(columnName);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.m_resultSet.do_getShort(columnName);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.m_resultSet.do_getInt(columnName);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.m_resultSet.do_getLong(columnName);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.m_resultSet.do_getFloat(columnName);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.m_resultSet.do_getDouble(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.m_resultSet.do_getBigDecimal(columnName, scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.m_resultSet.do_getBytes(columnName);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.m_resultSet.do_getDate(columnName);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.m_resultSet.do_getTime(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.m_resultSet.do_getTimestamp(columnName);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.m_resultSet.do_getAsciiStream(columnName);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.m_resultSet.do_getUnicodeStream(columnName);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.m_resultSet.do_getBinaryStream(columnName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.m_resultSet.do_getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_resultSet.do_clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.m_resultSet.do_getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new DmdbRowSetMetaData(this.m_resultSet.connection, this.m_resultSet.columns);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getObject(columnIndex, this.getTypeMap());
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.m_resultSet.do_getObject(columnName, this.getTypeMap());
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.m_resultSet.do_getCharacterStream(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.m_resultSet.do_getBigDecimal(columnName);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.m_resultSet.do_isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.m_resultSet.do_isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.m_resultSet.do_isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.m_resultSet.do_isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.m_resultSet.do_beforeFirst();
            this.notifyCursorMovement();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.m_resultSet.do_afterLast();
            this.notifyCursorMovement();
        }
    }

    @Override
    public boolean first() throws SQLException {
        boolean flag = this.m_resultSet.do_first();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean last() throws SQLException {
        boolean flag = this.m_resultSet.do_last();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public int getRow() throws SQLException {
        return this.m_resultSet.do_getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        boolean flag = this.m_resultSet.do_absolute(row);
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        boolean flag = this.m_resultSet.do_relative(rows);
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean flag = this.m_resultSet.do_previous();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.m_resultSet.do_rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.m_resultSet.do_rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.m_resultSet.do_rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.m_resultSet.do_updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x2) throws SQLException {
        this.m_resultSet.do_updateBoolean(columnIndex, x2);
    }

    @Override
    public void updateByte(int columnIndex, byte x2) throws SQLException {
        this.m_resultSet.do_updateByte(columnIndex, x2);
    }

    @Override
    public void updateShort(int columnIndex, short x2) throws SQLException {
        this.m_resultSet.do_updateShort(columnIndex, x2);
    }

    @Override
    public void updateInt(int columnIndex, int x2) throws SQLException {
        this.m_resultSet.do_updateInt(columnIndex, x2);
    }

    @Override
    public void updateLong(int columnIndex, long x2) throws SQLException {
        this.m_resultSet.do_updateLong(columnIndex, x2);
    }

    @Override
    public void updateFloat(int columnIndex, float x2) throws SQLException {
        this.m_resultSet.do_updateFloat(columnIndex, x2);
    }

    @Override
    public void updateDouble(int columnIndex, double x2) throws SQLException {
        this.m_resultSet.do_updateDouble(columnIndex, x2);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        this.m_resultSet.do_updateBigDecimal(columnIndex, x2);
    }

    @Override
    public void updateString(int columnIndex, String x2) throws SQLException {
        this.m_resultSet.do_updateString(columnIndex, x2);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x2) throws SQLException {
        this.m_resultSet.do_updateBytes(columnIndex, x2);
    }

    @Override
    public void updateDate(int columnIndex, Date x2) throws SQLException {
        this.m_resultSet.do_updateDate(columnIndex, x2);
    }

    @Override
    public void updateTime(int columnIndex, Time x2) throws SQLException {
        this.m_resultSet.do_updateTime(columnIndex, x2);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        this.m_resultSet.do_updateTimestamp(columnIndex, x2);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.m_resultSet.do_updateAsciiStream(columnIndex, x2, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.m_resultSet.do_updateBinaryStream(columnIndex, x2, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, int length) throws SQLException {
        this.m_resultSet.do_updateCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x2, int scale) throws SQLException {
        this.m_resultSet.do_updateObject(columnIndex, x2, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x2) throws SQLException {
        this.m_resultSet.do_updateObject(columnIndex, x2);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.m_resultSet.do_updateNull(columnName);
    }

    @Override
    public void updateBoolean(String columnName, boolean x2) throws SQLException {
        this.m_resultSet.do_updateBoolean(columnName, x2);
    }

    @Override
    public void updateByte(String columnName, byte x2) throws SQLException {
        this.m_resultSet.do_updateByte(columnName, x2);
    }

    @Override
    public void updateShort(String columnName, short x2) throws SQLException {
        this.m_resultSet.do_updateShort(columnName, x2);
    }

    @Override
    public void updateInt(String columnName, int x2) throws SQLException {
        this.m_resultSet.do_updateInt(columnName, x2);
    }

    @Override
    public void updateLong(String columnName, long x2) throws SQLException {
        this.m_resultSet.do_updateLong(columnName, x2);
    }

    @Override
    public void updateFloat(String columnName, float x2) throws SQLException {
        this.m_resultSet.do_updateFloat(columnName, x2);
    }

    @Override
    public void updateDouble(String columnName, double x2) throws SQLException {
        this.m_resultSet.do_updateDouble(columnName, x2);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x2) throws SQLException {
        this.m_resultSet.do_updateBigDecimal(columnName, x2);
    }

    @Override
    public void updateString(String columnName, String x2) throws SQLException {
        this.m_resultSet.do_updateString(columnName, x2);
    }

    @Override
    public void updateBytes(String columnName, byte[] x2) throws SQLException {
        this.m_resultSet.do_updateBytes(columnName, x2);
    }

    @Override
    public void updateDate(String columnName, Date x2) throws SQLException {
        this.m_resultSet.do_updateDate(columnName, x2);
    }

    @Override
    public void updateTime(String columnName, Time x2) throws SQLException {
        this.m_resultSet.do_updateTime(columnName, x2);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x2) throws SQLException {
        this.m_resultSet.do_updateTimestamp(columnName, x2);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x2, int length) throws SQLException {
        this.m_resultSet.do_updateAsciiStream(columnName, x2, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x2, int length) throws SQLException {
        this.m_resultSet.do_updateBinaryStream(columnName, x2, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.m_resultSet.do_updateCharacterStream(columnName, reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x2, int scale) throws SQLException {
        this.m_resultSet.do_updateObject(columnName, x2, scale);
    }

    @Override
    public void updateObject(String columnName, Object x2) throws SQLException {
        this.m_resultSet.do_updateObject(columnName, x2);
    }

    @Override
    public void insertRow() throws SQLException {
        this.m_resultSet.do_insertRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        this.m_resultSet.do_updateRow();
        this.notifyUpdateListeners();
        this.notifyRowSetChanged();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.m_resultSet.do_deleteRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.m_resultSet.do_refreshRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.m_resultSet.do_cancelRowUpdates();
        this.notifyRowChanged();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.m_resultSet.do_moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.m_resultSet.do_moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.m_resultSet.do_getStatement();
    }

    @Override
    public Object getObject(int i2, Map<String, Class<?>> map) throws SQLException {
        return this.m_resultSet.do_getObject(i2, map);
    }

    @Override
    public Ref getRef(int i2) throws SQLException {
        return this.m_resultSet.do_getRef(i2);
    }

    @Override
    public Blob getBlob(int i2) throws SQLException {
        return this.m_resultSet.do_getBlob(i2);
    }

    @Override
    public Clob getClob(int i2) throws SQLException {
        return this.m_resultSet.do_getClob(i2);
    }

    @Override
    public Array getArray(int i2) throws SQLException {
        return this.m_resultSet.do_getArray(i2);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.m_resultSet.do_getObject(colName, map);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.m_resultSet.do_getRef(colName);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.m_resultSet.do_getBlob(colName);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.m_resultSet.do_getClob(colName);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.m_resultSet.do_getArray(colName);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.do_getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.do_getDate(columnName, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.do_getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.do_getTime(columnName, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.do_getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.do_getTimestamp(columnName, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.m_resultSet.do_getURL(columnName);
    }

    @Override
    public void updateRef(int columnIndex, Ref x2) throws SQLException {
        this.m_resultSet.do_updateRef(columnIndex, x2);
    }

    @Override
    public void updateRef(String columnName, Ref x2) throws SQLException {
        this.m_resultSet.do_updateRef(columnName, x2);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x2) throws SQLException {
        this.m_resultSet.do_updateBlob(columnIndex, x2);
    }

    @Override
    public void updateBlob(String columnName, Blob x2) throws SQLException {
        this.m_resultSet.do_updateBlob(columnName, x2);
    }

    @Override
    public void updateClob(int columnIndex, Clob x2) throws SQLException {
        this.m_resultSet.do_updateClob(columnIndex, x2);
    }

    @Override
    public void updateClob(String columnName, Clob x2) throws SQLException {
        this.m_resultSet.do_updateClob(columnName, x2);
    }

    @Override
    public void updateArray(int columnIndex, Array x2) throws SQLException {
        this.m_resultSet.do_updateArray(columnIndex, x2);
    }

    @Override
    public void updateArray(String columnName, Array x2) throws SQLException {
        this.m_resultSet.do_updateArray(columnName, x2);
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        this.m_connection.do_commit();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.m_connection.do_getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        this.m_connection.do_setAutoCommit(autoCommit);
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        this.m_connection.do_rollback();
    }

    @Override
    public void rollback(Savepoint s2) throws SQLException {
        this.checkClosed();
        this.m_connection.do_rollback(s2);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.m_resultSet.do_findColumn(columnName);
    }

    public void checkClosed() throws SQLException {
        if (this.m_Closed || this.m_connection == null || this.m_connection.do_isClosed()) {
            DBError.ECJDBC_CONNECTION_CLOSED.throwz(new Object[0]);
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.m_callableStmt.do_setNull(parameterName, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.m_callableStmt.do_setNull(parameterName, sqlType, typeName);
    }

    @Override
    public void setBoolean(String parameterName, boolean x2) throws SQLException {
        this.m_callableStmt.do_setBoolean(parameterName, x2);
    }

    @Override
    public void setByte(String parameterName, byte x2) throws SQLException {
        this.m_callableStmt.do_setByte(parameterName, x2);
    }

    @Override
    public void setShort(String parameterName, short x2) throws SQLException {
        this.m_callableStmt.do_setShort(parameterName, x2);
    }

    @Override
    public void setInt(String parameterName, int x2) throws SQLException {
        this.m_callableStmt.do_setInt(parameterName, x2);
    }

    @Override
    public void setLong(String parameterName, long x2) throws SQLException {
        this.m_callableStmt.do_setLong(parameterName, x2);
    }

    @Override
    public void setFloat(String parameterName, float x2) throws SQLException {
        this.m_callableStmt.do_setFloat(parameterName, x2);
    }

    @Override
    public void setDouble(String parameterName, double x2) throws SQLException {
        this.m_callableStmt.do_setDouble(parameterName, x2);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x2) throws SQLException {
        this.m_callableStmt.do_setBigDecimal(parameterName, x2);
    }

    @Override
    public void setString(String parameterName, String x2) throws SQLException {
        this.m_callableStmt.do_setString(parameterName, x2);
    }

    @Override
    public void setBytes(String parameterName, byte[] x2) throws SQLException {
        this.m_callableStmt.do_setBytes(parameterName, x2);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x2) throws SQLException {
        this.m_callableStmt.do_setTimestamp(parameterName, x2);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.m_callableStmt.do_setAsciiStream(parameterName, x2, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x2, int length) throws SQLException {
        this.m_callableStmt.do_setBinaryStream(parameterName, x2, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.m_callableStmt.do_setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x2) throws SQLException {
        this.m_callableStmt.do_setAsciiStream(parameterIndex, x2);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x2) throws SQLException {
        this.m_callableStmt.do_setAsciiStream(parameterName, x2);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x2) throws SQLException {
        this.m_callableStmt.do_setBinaryStream(parameterIndex, x2);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x2) throws SQLException {
        this.m_callableStmt.do_setBinaryStream(parameterName, x2);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.do_setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.do_setCharacterStream(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.m_callableStmt.do_setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setObject(String parameterName, Object x2, int targetSqlType, int scale) throws SQLException {
        this.m_callableStmt.do_setObject(parameterName, x2, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x2, int targetSqlType) throws SQLException {
        this.m_callableStmt.do_setObject(parameterName, x2, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x2) throws SQLException {
        this.m_callableStmt.do_setObject(parameterName, x2);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.m_callableStmt.do_setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.m_callableStmt.do_setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.m_callableStmt.do_setBlob(parameterName, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x2) throws SQLException {
        this.m_callableStmt.do_setBlob(parameterName, x2);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.m_callableStmt.do_setBlob(parameterName, inputStream);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.m_callableStmt.do_setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.do_setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.m_callableStmt.do_setClob(parameterName, reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x2) throws SQLException {
        this.m_callableStmt.do_setClob(parameterName, x2);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.do_setClob(parameterName, reader);
    }

    @Override
    public void setDate(String parameterName, Date x2) throws SQLException {
        this.m_callableStmt.do_setDate(parameterName, x2);
    }

    @Override
    public void setDate(String parameterName, Date x2, Calendar cal) throws SQLException {
        this.m_callableStmt.do_setDate(parameterName, x2, cal);
    }

    @Override
    public void setTime(String parameterName, Time x2) throws SQLException {
        this.m_callableStmt.do_setTime(parameterName, x2);
    }

    @Override
    public void setTime(String parameterName, Time x2, Calendar cal) throws SQLException {
        this.m_callableStmt.do_setTime(parameterName, x2, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x2, Calendar cal) throws SQLException {
        this.m_callableStmt.do_setTimestamp(parameterName, x2, cal);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.m_callableStmt.do_setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.m_callableStmt.do_setSQLXML(parameterName, xmlObject);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x2) throws SQLException {
        this.m_callableStmt.do_setRowId(parameterIndex, x2);
    }

    @Override
    public void setRowId(String parameterName, RowId x2) throws SQLException {
        this.m_callableStmt.do_setRowId(parameterName, x2);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.m_callableStmt.do_setNString(parameterIndex, value);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.m_callableStmt.do_setNString(parameterName, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.m_callableStmt.do_setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.m_callableStmt.do_setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.m_callableStmt.do_setNCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.m_callableStmt.do_setNClob(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.m_callableStmt.do_setNClob(parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.do_setNClob(parameterName, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.m_callableStmt.do_setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.m_callableStmt.do_setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.do_setNClob(parameterIndex, reader);
    }

    @Override
    public void setURL(int parameterIndex, URL x2) throws SQLException {
        this.m_callableStmt.do_setURL(parameterIndex, x2);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.m_resultSet.do_getRowId(columnLabel);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x2) throws SQLException {
        this.m_resultSet.do_updateRowId(columnIndex, x2);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x2) throws SQLException {
        this.m_resultSet.do_updateRowId(columnLabel, x2);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.m_resultSet.do_getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_Closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.m_resultSet.do_updateNString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.m_resultSet.do_updateNString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.m_resultSet.do_updateNClob(columnIndex, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.m_resultSet.do_updateNClob(columnLabel, nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.m_resultSet.do_getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.m_resultSet.do_getSQLXML(columnLabel);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.m_resultSet.do_updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.m_resultSet.do_updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.m_resultSet.do_getNString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.m_resultSet.do_getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.m_resultSet.do_getNCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.m_resultSet.do_updateNCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.do_updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.m_resultSet.do_updateAsciiStream(columnIndex, x2, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, long length) throws SQLException {
        this.m_resultSet.do_updateBinaryStream(columnIndex, x2, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.m_resultSet.do_updateCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.m_resultSet.do_updateAsciiStream(columnLabel, x2, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2, long length) throws SQLException {
        this.m_resultSet.do_updateBinaryStream(columnLabel, x2, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.do_updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.m_resultSet.do_updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.m_resultSet.do_updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.m_resultSet.do_updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.do_updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.m_resultSet.do_updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.do_updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.m_resultSet.do_updateNCharacterStream(columnIndex, x2);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.do_updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2) throws SQLException {
        this.m_resultSet.do_updateAsciiStream(columnIndex, x2);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2) throws SQLException {
        this.m_resultSet.do_updateBinaryStream(columnIndex, x2);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.m_resultSet.do_updateCharacterStream(columnIndex, x2);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2) throws SQLException {
        this.m_resultSet.do_updateAsciiStream(columnLabel, x2);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2) throws SQLException {
        this.m_resultSet.do_updateBinaryStream(columnLabel, x2);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.do_updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.m_resultSet.do_updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.m_resultSet.do_updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.m_resultSet.do_updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.do_updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.m_resultSet.do_updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.do_updateNClob(columnLabel, reader);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.m_resultSet.do_getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.m_resultSet.do_getObject(columnLabel, type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

