/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.conf;

import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Comparator;

public class EP
implements Serializable,
Cloneable {
    public String host;
    public int port;
    public int epSeqno;
    public boolean alive;
    public long statusRefreshTime = 0L;
    public int serverMode = -1;
    public int serverStatus = -1;
    public boolean dscControl = false;
    public static final int EP_STATUS_OK = 1;
    public static final int EP_STATUS_ERROR = 2;
    public int epStatus;
    public long sessions = 0L;
    public static final Comparator<EP> sessionComparator = new Comparator<EP>(){

        @Override
        public int compare(EP o1, EP o2) {
            return o1.sessions < o2.sessions ? -1 : (o1.sessions == o2.sessions ? 0 : 1);
        }
    };
    public static final int SORT_SERVER_MODE_INVALID = -1;
    public static final int SORT_SERVER_NOT_ALIVE = -2;
    public static final int SORT_NORMAL = 30;
    public static final int SORT_PRIMARY = 20;
    public static final int SORT_STANDBY = 10;
    public static final int SORT_OPEN = 3;
    public static final int SORT_MOUNT = 2;
    public static final int SORT_SUSPEND = 1;
    public static final int SORT_UNKNOWN = Integer.MAX_VALUE;
    public int sort = Integer.MAX_VALUE;
    public static final int STATUS_REFRESH_MILLISECOND = 20000;

    public EP(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public EP(String host, int port, long sessions) {
        this.host = host;
        this.port = port;
        this.sessions = sessions;
    }

    public String toString() {
        return String.valueOf(StringUtil.trimToEmpty(this.host)) + ":" + this.port + " (" + EP.getServerModeDesc(this.serverMode) + ", " + EP.getServerStatusDesc(this.serverStatus) + (this.dscControl ? ", DSC CONTROL)" : ")") + ", sessions: " + this.sessions;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EP)) {
            return false;
        }
        EP ep = (EP)obj;
        return StringUtil.equals(this.host, ep.host) && this.port == ep.port;
    }

    public void connect(DmdbConnection conn) throws SQLException {
        conn.ep = this;
        conn.host = this.host;
        conn.port = this.port;
        conn.props.setProperty(Configuration.host.getName(), this.host);
        conn.props.setProperty(Configuration.port.getName(), String.valueOf(this.port));
        try {
            conn.openConnection();
            this.refreshStatus(true, conn);
        }
        catch (SQLException e2) {
            this.refreshStatus(false, conn);
            throw e2;
        }
    }

    private int calcSort(int loginMode) {
        int sort = 0;
        block0 : switch (loginMode) {
            case 0: {
                switch (this.serverMode) {
                    case 0: {
                        sort += 300;
                        break block0;
                    }
                    case 1: {
                        sort += 2000;
                        break block0;
                    }
                    case 2: {
                        sort += 10;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (this.serverMode) {
                    case 0: {
                        sort += 30;
                        break block0;
                    }
                    case 1: {
                        sort += 200;
                        break block0;
                    }
                    case 2: {
                        sort += 1000;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (this.serverMode) {
                    case 2: {
                        sort += 10;
                        break block0;
                    }
                    case 1: {
                        sort += 200;
                        break block0;
                    }
                    case 0: {
                        sort += 3000;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (this.serverMode != 1) {
                    return -1;
                }
                sort += 20;
                break;
            }
            case 2: {
                if (this.serverMode != 2) {
                    return -1;
                }
                sort += 10;
                break;
            }
        }
        switch (this.serverStatus) {
            case 3: {
                sort += 2;
                break;
            }
            case 4: {
                sort += 3;
                break;
            }
            case 5: {
                ++sort;
                break;
            }
        }
        return sort;
    }

    private synchronized void refreshStatus(boolean alive, DmdbConnection conn) {
        this.alive = alive;
        this.statusRefreshTime = System.currentTimeMillis();
        this.serverMode = alive ? conn.svrMode : -1;
        this.serverStatus = alive ? conn.svrStat : -1;
        this.dscControl = alive ? conn.dscControl : false;
        this.sort = alive ? this.calcSort(conn.epGroup.loginMode) : -2;
        conn.epGroup.checkTime = this.statusRefreshTime;
    }

    public static String getServerStatusDesc(int serverStatus) {
        String ret = "";
        switch (serverStatus) {
            case 4: {
                ret = "OPEN";
                break;
            }
            case 3: {
                ret = "MOUNT";
                break;
            }
            case 5: {
                ret = "SUSPEND";
                break;
            }
            default: {
                ret = "UNKNOW";
            }
        }
        return ret;
    }

    public static String getServerModeDesc(int serverMode) {
        String ret = "";
        switch (serverMode) {
            case 0: {
                ret = "NORMAL";
                break;
            }
            case 1: {
                ret = "PRIMARY";
                break;
            }
            case 2: {
                ret = "STANDBY";
                break;
            }
            default: {
                ret = "UNKNOW";
            }
        }
        return ret;
    }
}

