/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.desc;

public class BooleanExpression {
    public static final String REGULAR = "";
    public static final int OP_EQUAL = 1;
    public static final int OP_NOT_EQUAL = 2;
    public static final int OP_LESS = 3;
    public static final int OP_LESS_EQUAL = 4;
    public static final int OP_GREATER = 5;
    public static final int OP_GREATER_EQUAL = 6;
    public static final int OP_IN = 7;
    public static final int OP_NOT_IN = 8;
    int op;
    int var;
    int[] vars;

    public BooleanExpression(int op, int var) {
        this.op = op;
        this.var = var;
    }

    public BooleanExpression(int op, int[] vars) {
        this.op = op;
        this.vars = vars;
    }

    public boolean execute(int value) {
        switch (this.op) {
            case 1: {
                return value == this.var;
            }
            case 2: {
                return value != this.var;
            }
            case 3: {
                return value < this.var;
            }
            case 4: {
                return value <= this.var;
            }
            case 5: {
                return value > this.var;
            }
            case 6: {
                return value >= this.var;
            }
            case 7: {
                int[] nArray = this.vars;
                int n2 = this.vars.length;
                int n3 = 0;
                while (n3 < n2) {
                    int e2 = nArray[n3];
                    if (e2 == value) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            case 8: {
                int[] nArray = this.vars;
                int n4 = this.vars.length;
                int n5 = 0;
                while (n5 < n4) {
                    int e3 = nArray[n5];
                    if (e3 == value) {
                        return false;
                    }
                    ++n5;
                }
                return true;
            }
        }
        return false;
    }
}

