/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event;

import com.dangdang.ddframe.job.event.JobEvent;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.JobEventListener;
import com.dangdang.ddframe.job.util.concurrent.ExecutorServiceObject;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class JobEventBus {
    private static volatile JobEventBus instance;
    private final ConcurrentHashMap<String, JobEventBusInstance> itemMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobEventBus getInstance() {
        if (null != instance) return instance;
        Class<JobEventBus> clazz = JobEventBus.class;
        synchronized (JobEventBus.class) {
            if (null != instance) return instance;
            instance = new JobEventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(String jobName, Collection<JobEventConfiguration> jobEventConfigs) {
        JobEventBusInstance newValue = new JobEventBusInstance();
        JobEventBusInstance originalValue = this.itemMap.putIfAbsent(jobName, newValue);
        if (null != originalValue) {
            originalValue.register(jobEventConfigs);
        } else {
            newValue.register(jobEventConfigs);
        }
    }

    public void deregister(String jobName) {
        JobEventBusInstance jobEventBusInstance = this.itemMap.remove(jobName);
        if (null != jobEventBusInstance) {
            jobEventBusInstance.clearListeners();
        }
    }

    public void post(JobEvent jobEvent) {
        JobEventBusInstance jobEventBusInstance = this.itemMap.get(jobEvent.getJobName());
        if (null != jobEventBusInstance) {
            jobEventBusInstance.post(jobEvent);
        }
    }

    public void clearListeners(String jobName) {
        JobEventBusInstance jobEventBusInstance = this.itemMap.get(jobName);
        if (null != jobEventBusInstance) {
            jobEventBusInstance.clearListeners();
        }
    }

    public Map<String, Integer> getWorkQueueSize() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, JobEventBusInstance> each : this.itemMap.entrySet()) {
            result.put(each.getKey(), each.getValue().getExecutorServiceObject().getWorkQueueSize());
        }
        return result;
    }

    public Map<String, Integer> getActiveThreadCount() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, JobEventBusInstance> each : this.itemMap.entrySet()) {
            result.put(each.getKey(), each.getValue().getExecutorServiceObject().getActiveThreadCount());
        }
        return result;
    }

    private JobEventBus() {
    }

    class JobEventBusInstance {
        private final ExecutorServiceObject executorServiceObject;
        private final EventBus eventBus;
        private final ConcurrentHashMap<String, JobEventListener> listeners = new ConcurrentHashMap();

        JobEventBusInstance() {
            this.executorServiceObject = new ExecutorServiceObject("job-event", Runtime.getRuntime().availableProcessors() * 2);
            this.eventBus = new AsyncEventBus((Executor)this.executorServiceObject.createExecutorService());
        }

        void register(Collection<JobEventConfiguration> jobEventConfigs) {
            for (JobEventConfiguration each : jobEventConfigs) {
                this.register(each.createJobEventListener());
            }
        }

        private void register(JobEventListener listener) {
            if (null != listener && null == this.listeners.putIfAbsent(listener.getIdentity(), listener)) {
                this.eventBus.register((Object)listener);
            }
        }

        void post(Object event) {
            if (!this.listeners.isEmpty() && !this.executorServiceObject.isShutdown()) {
                this.eventBus.post(event);
            }
        }

        synchronized void clearListeners() {
            for (JobEventListener each : this.listeners.values()) {
                this.eventBus.unregister((Object)each);
            }
            this.listeners.clear();
        }

        public ExecutorServiceObject getExecutorServiceObject() {
            return this.executorServiceObject;
        }
    }
}

