/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event;

import com.dangdang.ddframe.job.event.JobEvent;
import com.dangdang.ddframe.job.util.env.LocalHostService;
import java.beans.ConstructorProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.UUID;

public class JobExecutionEvent
implements JobEvent {
    private static LocalHostService localHostService = new LocalHostService();
    private final String id = UUID.randomUUID().toString();
    private final String hostname = localHostService.getHostName();
    private final String ip = localHostService.getIp();
    private final String jobName;
    private final ExecutionSource source;
    private final int shardingItem;
    private final Date startTime = new Date();
    private Date completeTime;
    private boolean success;
    private Throwable failureCause;

    public void executionSuccess() {
        this.completeTime = new Date();
        this.success = true;
    }

    public void executionFailure(Throwable failureCause) {
        this.completeTime = new Date();
        this.success = false;
        this.failureCause = failureCause;
    }

    public String getFailureCause() {
        if (null == this.failureCause) {
            return "";
        }
        StringWriter result = new StringWriter();
        try (PrintWriter writer = new PrintWriter(result);){
            this.failureCause.printStackTrace(writer);
        }
        return result.toString();
    }

    @ConstructorProperties(value={"jobName", "source", "shardingItem"})
    public JobExecutionEvent(String jobName, ExecutionSource source, int shardingItem) {
        this.jobName = jobName;
        this.source = source;
        this.shardingItem = shardingItem;
    }

    public String getId() {
        return this.id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIp() {
        return this.ip;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    public ExecutionSource getSource() {
        return this.source;
    }

    public int getShardingItem() {
        return this.shardingItem;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getCompleteTime() {
        return this.completeTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public static enum ExecutionSource {
        NORMAL_TRIGGER,
        MISFIRE,
        FAILOVER;

    }
}

