/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.event;

import com.dangdang.ddframe.job.event.JobEvent;
import com.dangdang.ddframe.job.util.env.LocalHostService;
import java.beans.ConstructorProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class JobTraceEvent
implements JobEvent {
    private static LocalHostService localHostService = new LocalHostService();
    private final String jobName;
    private final LogLevel logLevel;
    private final String message;
    private Throwable failureCause;
    private final String hostname = localHostService.getHostName();
    private final String ip = localHostService.getIp();
    private final Date creationTime = new Date();

    public String getFailureCause() {
        if (null == this.failureCause) {
            return "";
        }
        StringWriter result = new StringWriter();
        try (PrintWriter writer = new PrintWriter(result);){
            this.failureCause.printStackTrace(writer);
        }
        return result.toString();
    }

    @ConstructorProperties(value={"jobName", "logLevel", "message"})
    public JobTraceEvent(String jobName, LogLevel logLevel, String message) {
        this.jobName = jobName;
        this.logLevel = logLevel;
        this.message = message;
    }

    @ConstructorProperties(value={"jobName", "logLevel", "message", "failureCause"})
    public JobTraceEvent(String jobName, LogLevel logLevel, String message, Throwable failureCause) {
        this.jobName = jobName;
        this.logLevel = logLevel;
        this.message = message;
        this.failureCause = failureCause;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getMessage() {
        return this.message;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIp() {
        return this.ip;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

