/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.api;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.script.ScriptJob;
import com.dangdang.ddframe.job.exception.JobConfigurationException;
import com.dangdang.ddframe.job.exception.JobSystemException;
import com.dangdang.ddframe.job.executor.JobExecutorFactory;
import com.dangdang.ddframe.job.executor.JobFacade;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.executor.JobExecutor;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.lite.internal.schedule.LiteJobFacade;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.Arrays;
import java.util.Properties;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.plugins.management.ShutdownHookPlugin;
import org.quartz.simpl.SimpleThreadPool;

public class JobScheduler {
    public static final String ELASTIC_JOB_DATA_MAP_KEY = "elasticJob";
    private static final String JOB_FACADE_DATA_MAP_KEY = "jobFacade";
    private final JobExecutor jobExecutor;
    private final JobFacade jobFacade;

    public JobScheduler(CoordinatorRegistryCenter regCenter, LiteJobConfiguration liteJobConfig, ElasticJobListener ... elasticJobListeners) {
        this.jobExecutor = new JobExecutor(regCenter, liteJobConfig, elasticJobListeners);
        this.jobFacade = new LiteJobFacade(regCenter, liteJobConfig.getJobName(), Arrays.asList(elasticJobListeners));
    }

    public void init() {
        JobScheduleController jobScheduleController;
        this.jobExecutor.init();
        JobDetail jobDetail = JobBuilder.newJob(LiteJob.class).withIdentity(this.jobExecutor.getLiteJobConfig().getJobName()).build();
        try {
            if (!this.jobExecutor.getLiteJobConfig().getTypeConfig().getJobClass().equals(ScriptJob.class.getCanonicalName())) {
                jobDetail.getJobDataMap().put(ELASTIC_JOB_DATA_MAP_KEY, Class.forName(this.jobExecutor.getLiteJobConfig().getTypeConfig().getJobClass()).newInstance());
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new JobConfigurationException("Elastic-Job: Job class '%s' can not initialize.", new Object[]{this.jobExecutor.getLiteJobConfig().getTypeConfig().getJobClass()});
        }
        jobDetail.getJobDataMap().put(JOB_FACADE_DATA_MAP_KEY, (Object)this.jobFacade);
        try {
            jobScheduleController = new JobScheduleController(this.initializeScheduler(jobDetail.getKey().toString()), jobDetail, this.jobExecutor.getSchedulerFacade(), this.jobExecutor.getLiteJobConfig().getJobName());
            jobScheduleController.scheduleJob(this.jobExecutor.getSchedulerFacade().loadJobConfiguration().getTypeConfig().getCoreConfig().getCron());
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
        JobRegistry.getInstance().addJobScheduleController(this.jobExecutor.getLiteJobConfig().getJobName(), jobScheduleController);
    }

    private Scheduler initializeScheduler(String jobName) throws SchedulerException {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        factory.initialize(this.getBaseQuartzProperties(jobName));
        Scheduler result = factory.getScheduler();
        result.getListenerManager().addTriggerListener((TriggerListener)this.jobExecutor.getSchedulerFacade().newJobTriggerListener());
        return result;
    }

    private Properties getBaseQuartzProperties(String jobName) {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", "1");
        result.put("org.quartz.scheduler.instanceName", jobName);
        if (!this.jobExecutor.getSchedulerFacade().loadJobConfiguration().getTypeConfig().getCoreConfig().isMisfire()) {
            result.put("org.quartz.jobStore.misfireThreshold", "1");
        }
        result.put("org.quartz.plugin.shutdownhook.class", ShutdownHookPlugin.class.getName());
        result.put("org.quartz.plugin.shutdownhook.cleanShutdown", Boolean.TRUE.toString());
        this.prepareEnvironments(result);
        return result;
    }

    protected void prepareEnvironments(Properties props) {
    }

    public void shutdown() {
        JobRegistry.getInstance().getJobScheduleController(this.jobExecutor.getLiteJobConfig().getJobName()).shutdown();
    }

    public static final class LiteJob
    implements Job {
        private ElasticJob elasticJob;
        private JobFacade jobFacade;

        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobExecutorFactory.getJobExecutor((ElasticJob)this.elasticJob, (JobFacade)this.jobFacade).execute();
        }

        public void setElasticJob(ElasticJob elasticJob) {
            this.elasticJob = elasticJob;
        }

        public void setJobFacade(JobFacade jobFacade) {
            this.jobFacade = jobFacade;
        }
    }
}

