/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.election;

import com.dangdang.ddframe.job.event.JobEvent;
import com.dangdang.ddframe.job.event.JobEventBus;
import com.dangdang.ddframe.job.event.JobTraceEvent;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.lite.internal.storage.LeaderExecutionCallback;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.util.BlockUtils;
import com.dangdang.ddframe.job.util.env.LocalHostService;
import java.beans.ConstructorProperties;

public class LeaderElectionService {
    private final LocalHostService localHostService = new LocalHostService();
    private final String jobName;
    private final ServerService serverService;
    private final JobNodeStorage jobNodeStorage;

    public LeaderElectionService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
    }

    public void leaderForceElection() {
        this.jobNodeStorage.executeInLeader("leader/election/latch", new LeaderElectionExecutionCallback(true));
    }

    public void leaderElection() {
        this.jobNodeStorage.executeInLeader("leader/election/latch", new LeaderElectionExecutionCallback(false));
    }

    public Boolean isLeader() {
        String localHostIp = this.localHostService.getIp();
        while (!this.hasLeader() && !this.serverService.getAvailableServers().isEmpty()) {
            JobEventBus.getInstance().post((JobEvent)new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.INFO, "Leader node is electing, waiting for 100 ms"));
            BlockUtils.waitingShortTime();
            this.leaderElection();
        }
        return localHostIp.equals(this.jobNodeStorage.getJobNodeData("leader/election/host"));
    }

    public boolean hasLeader() {
        return this.jobNodeStorage.isJobNodeExisted("leader/election/host");
    }

    public void removeLeader() {
        this.jobNodeStorage.removeJobNodeIfExisted("leader/election/host");
    }

    class LeaderElectionExecutionCallback
    implements LeaderExecutionCallback {
        private final boolean isForceElect;

        @Override
        public void execute() {
            if (!LeaderElectionService.this.jobNodeStorage.isJobNodeExisted("leader/election/host") && (this.isForceElect || LeaderElectionService.this.serverService.isAvailableServer(LeaderElectionService.this.localHostService.getIp()))) {
                LeaderElectionService.this.jobNodeStorage.fillEphemeralJobNode("leader/election/host", LeaderElectionService.this.localHostService.getIp());
            }
        }

        @ConstructorProperties(value={"isForceElect"})
        public LeaderElectionExecutionCallback(boolean isForceElect) {
            this.isForceElect = isForceElect;
        }
    }
}

