/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.execution;

import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;

public final class ExecutionNode {
    public static final String ROOT = "execution";
    static final String RUNNING_APPENDIX = "running";
    static final String RUNNING = "execution/%s/running";
    static final String COMPLETED = "execution/%s/completed";
    static final String LAST_BEGIN_TIME = "execution/%s/lastBeginTime";
    static final String NEXT_FIRE_TIME = "execution/%s/nextFireTime";
    static final String LAST_COMPLETE_TIME = "execution/%s/lastCompleteTime";
    static final String MISFIRE = "execution/%s/misfire";
    static final String LEADER_ROOT = "leader/execution";
    static final String NECESSARY = "leader/execution/necessary";
    static final String CLEANING = "leader/execution/cleaning";
    private final JobNodePath jobNodePath;

    public ExecutionNode(String jobName) {
        this.jobNodePath = new JobNodePath(jobName);
    }

    public static String getRunningNode(int item) {
        return String.format(RUNNING, item);
    }

    static String getCompletedNode(int item) {
        return String.format(COMPLETED, item);
    }

    static String getLastBeginTimeNode(int item) {
        return String.format(LAST_BEGIN_TIME, item);
    }

    static String getNextFireTimeNode(int item) {
        return String.format(NEXT_FIRE_TIME, item);
    }

    static String getLastCompleteTimeNode(int item) {
        return String.format(LAST_COMPLETE_TIME, item);
    }

    static String getMisfireNode(int item) {
        return String.format(MISFIRE, item);
    }

    public Integer getItemByRunningItemPath(String path) {
        if (!this.isRunningItemPath(path)) {
            return null;
        }
        return Integer.parseInt(path.substring(this.jobNodePath.getFullPath(ROOT).length() + 1, path.lastIndexOf(RUNNING_APPENDIX) - 1));
    }

    private boolean isRunningItemPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(ROOT)) && path.endsWith(RUNNING_APPENDIX);
    }
}

