/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.execution;

import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.election.LeaderElectionService;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionNode;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.server.ServerStatus;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.util.BlockUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ExecutionService {
    private final String jobName;
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;
    private final ServerService serverService;
    private final LeaderElectionService leaderElectionService;

    public ExecutionService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.configService = new ConfigurationService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.leaderElectionService = new LeaderElectionService(regCenter, jobName);
    }

    public void registerJobBegin(ShardingContexts shardingContexts) {
        if (!shardingContexts.getShardingItemParameters().isEmpty() && this.configService.load(true).isMonitorExecution()) {
            this.serverService.updateServerStatus(ServerStatus.RUNNING);
            Iterator iterator = shardingContexts.getShardingItemParameters().keySet().iterator();
            while (iterator.hasNext()) {
                Date nextFireTime;
                int each = (Integer)iterator.next();
                this.jobNodeStorage.fillEphemeralJobNode(ExecutionNode.getRunningNode(each), "");
                this.jobNodeStorage.replaceJobNode(ExecutionNode.getLastBeginTimeNode(each), System.currentTimeMillis());
                JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(this.jobName);
                if (null == jobScheduleController || null == (nextFireTime = jobScheduleController.getNextFireTime())) continue;
                this.jobNodeStorage.replaceJobNode(ExecutionNode.getNextFireTimeNode(each), nextFireTime.getTime());
            }
        }
    }

    public void cleanPreviousExecutionInfo() {
        if (!this.jobNodeStorage.isJobNodeExisted("execution")) {
            return;
        }
        if (this.leaderElectionService.isLeader().booleanValue()) {
            this.jobNodeStorage.fillEphemeralJobNode("leader/execution/cleaning", "");
            List<Integer> items = this.getAllItems();
            for (int each : items) {
                this.jobNodeStorage.removeJobNodeIfExisted(ExecutionNode.getCompletedNode(each));
            }
            if (this.jobNodeStorage.isJobNodeExisted("leader/execution/necessary")) {
                this.fixExecutionInfo(items);
            }
            this.jobNodeStorage.removeJobNodeIfExisted("leader/execution/cleaning");
        }
        while (this.jobNodeStorage.isJobNodeExisted("leader/execution/cleaning")) {
            BlockUtils.waitingShortTime();
        }
    }

    private void fixExecutionInfo(List<Integer> items) {
        int currentShardingTotalCount;
        int newShardingTotalCount = this.configService.load(false).getTypeConfig().getCoreConfig().getShardingTotalCount();
        if (newShardingTotalCount > (currentShardingTotalCount = items.size())) {
            for (int i = currentShardingTotalCount; i < newShardingTotalCount; ++i) {
                this.jobNodeStorage.createJobNodeIfNeeded("execution/" + i);
            }
        } else if (newShardingTotalCount < currentShardingTotalCount) {
            for (int i = newShardingTotalCount; i < currentShardingTotalCount; ++i) {
                this.jobNodeStorage.removeJobNodeIfExisted("execution/" + i);
            }
        }
        this.jobNodeStorage.removeJobNodeIfExisted("leader/execution/necessary");
    }

    public void registerJobCompleted(ShardingContexts shardingContexts) {
        if (!this.configService.load(true).isMonitorExecution()) {
            return;
        }
        this.serverService.updateServerStatus(ServerStatus.READY);
        Iterator iterator = shardingContexts.getShardingItemParameters().keySet().iterator();
        while (iterator.hasNext()) {
            int each = (Integer)iterator.next();
            this.jobNodeStorage.createJobNodeIfNeeded(ExecutionNode.getCompletedNode(each));
            this.jobNodeStorage.removeJobNodeIfExisted(ExecutionNode.getRunningNode(each));
            this.jobNodeStorage.replaceJobNode(ExecutionNode.getLastCompleteTimeNode(each), System.currentTimeMillis());
        }
    }

    public void setNeedFixExecutionInfoFlag() {
        this.jobNodeStorage.createJobNodeIfNeeded("leader/execution/necessary");
    }

    public void clearRunningInfo(List<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ExecutionNode.getRunningNode(each));
        }
    }

    public boolean misfireIfNecessary(Collection<Integer> items) {
        if (this.hasRunningItems(items)) {
            this.setMisfire(items);
            return true;
        }
        return false;
    }

    public void setMisfire(Collection<Integer> items) {
        if (!this.configService.load(true).isMonitorExecution()) {
            return;
        }
        for (int each : items) {
            this.jobNodeStorage.createJobNodeIfNeeded(ExecutionNode.getMisfireNode(each));
        }
    }

    public List<Integer> getMisfiredJobItems(Collection<Integer> items) {
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ExecutionNode.getMisfireNode(each))) continue;
            result.add(each);
        }
        return result;
    }

    public void clearMisfire(Collection<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ExecutionNode.getMisfireNode(each));
        }
    }

    public void removeExecutionInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("execution");
    }

    public boolean isCompleted(int item) {
        return this.jobNodeStorage.isJobNodeExisted(ExecutionNode.getCompletedNode(item));
    }

    public boolean hasRunningItems(Collection<Integer> items) {
        if (!this.configService.load(true).isMonitorExecution()) {
            return false;
        }
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ExecutionNode.getRunningNode(each))) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningItems() {
        return this.hasRunningItems(this.getAllItems());
    }

    private List<Integer> getAllItems() {
        return Lists.transform(this.jobNodeStorage.getJobNodeChildrenKeys("execution"), (Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.parseInt(input);
            }
        });
    }
}

