/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.monitor;

import com.dangdang.ddframe.job.event.JobEvent;
import com.dangdang.ddframe.job.event.JobEventBus;
import com.dangdang.ddframe.job.event.JobTraceEvent;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.util.SensitiveInfoUtils;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;

public class MonitorService {
    public static final String DUMP_COMMAND = "dump";
    private final String jobName;
    private final CoordinatorRegistryCenter regCenter;
    private final ConfigurationService configService;
    private ServerSocket serverSocket;
    private volatile boolean closed;

    public MonitorService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.regCenter = regCenter;
        this.configService = new ConfigurationService(regCenter, jobName);
    }

    public void listen() {
        int port = this.configService.load(true).getMonitorPort();
        if (port < 0) {
            return;
        }
        try {
            JobEventBus.getInstance().post((JobEvent)new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.INFO, String.format("Monitor service is running, the port is: '%s'.", port)));
            this.openSocketForMonitor(port);
        }
        catch (IOException ex) {
            JobEventBus.getInstance().post((JobEvent)new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.ERROR, "Monitor socket initialize failure.", (Throwable)ex));
        }
    }

    private void openSocketForMonitor(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        new Thread(){

            @Override
            public void run() {
                while (!MonitorService.this.closed) {
                    try {
                        MonitorService.this.process(MonitorService.this.serverSocket.accept());
                    }
                    catch (IOException ex) {
                        JobEventBus.getInstance().post((JobEvent)new JobTraceEvent(MonitorService.this.jobName, JobTraceEvent.LogLevel.ERROR, "Monitor socket initialize failure.", (Throwable)ex));
                    }
                }
            }
        }.start();
    }

    private void process(Socket socket) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
             Socket autoCloseSocket = socket;){
            String cmdLine = reader.readLine();
            if (null != cmdLine && DUMP_COMMAND.equalsIgnoreCase(cmdLine)) {
                ArrayList<String> result = new ArrayList<String>();
                this.dumpDirectly("/" + this.jobName, result);
                this.outputMessage(writer, Joiner.on((String)"\n").join(SensitiveInfoUtils.filterSensitiveIps(result)) + "\n");
            }
        }
    }

    private void dumpDirectly(String path, List<String> result) {
        for (String each : this.regCenter.getChildrenKeys(path)) {
            String treeCacheValue;
            TreeCache treeCache;
            ChildData treeCacheData;
            String zkPath = path + "/" + each;
            String zkValue = this.regCenter.get(zkPath);
            if (null == zkValue) {
                zkValue = "";
            }
            String treeCachePath = null == (treeCacheData = (treeCache = (TreeCache)this.regCenter.getRawCache("/" + this.jobName)).getCurrentData(zkPath)) ? "" : treeCacheData.getPath();
            String string = treeCacheValue = null == treeCacheData ? "" : new String(treeCacheData.getData());
            if (zkValue.equals(treeCacheValue) && zkPath.equals(treeCachePath)) {
                result.add(Joiner.on((String)" | ").join((Object)zkPath, (Object)zkValue, new Object[0]));
            } else {
                result.add(Joiner.on((String)" | ").join((Object)zkPath, (Object)zkValue, new Object[]{treeCachePath, treeCacheValue}));
            }
            this.dumpDirectly(zkPath, result);
        }
    }

    private void outputMessage(BufferedWriter outputWriter, String msg) throws IOException {
        outputWriter.append(msg);
        outputWriter.flush();
    }

    public void close() {
        this.closed = true;
        if (null != this.serverSocket && !this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                JobEventBus.getInstance().post((JobEvent)new JobTraceEvent(this.jobName, JobTraceEvent.LogLevel.ERROR, "Monitor socket close failure.", (Throwable)ex));
            }
        }
    }
}

