/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.schedule;

import com.dangdang.ddframe.job.exception.JobSystemException;
import com.dangdang.ddframe.job.lite.internal.schedule.SchedulerFacade;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class JobScheduleController {
    private final Scheduler scheduler;
    private final JobDetail jobDetail;
    private final SchedulerFacade schedulerFacade;
    private final String triggerIdentity;

    public void scheduleJob(String cronExpression) {
        try {
            if (!this.scheduler.checkExists(this.jobDetail.getKey())) {
                this.scheduler.scheduleJob(this.jobDetail, (Trigger)this.createTrigger(cronExpression));
            }
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public void rescheduleJob(String cron) {
        try {
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(TriggerKey.triggerKey((String)this.triggerIdentity));
            if (!this.scheduler.isShutdown() && null != trigger && !cron.equals(trigger.getCronExpression())) {
                this.scheduler.rescheduleJob(TriggerKey.triggerKey((String)this.triggerIdentity), (Trigger)this.createTrigger(cron));
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    private CronTrigger createTrigger(String cronExpression) {
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
        cronScheduleBuilder = this.schedulerFacade.loadJobConfiguration().getTypeConfig().getCoreConfig().isMisfire() ? cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed() : cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
        return (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.triggerIdentity).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
    }

    public Date getNextFireTime() {
        List triggers;
        try {
            triggers = this.scheduler.getTriggersOfJob(this.jobDetail.getKey());
        }
        catch (SchedulerException ex) {
            return null;
        }
        Date result = null;
        for (Trigger each : triggers) {
            Date nextFireTime = each.getNextFireTime();
            if (null == nextFireTime) continue;
            if (null == result) {
                result = nextFireTime;
                continue;
            }
            if (nextFireTime.getTime() >= result.getTime()) continue;
            result = nextFireTime;
        }
        return result;
    }

    public void pauseJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.pauseAll();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public void resumeJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.resumeAll();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public void triggerJob() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.triggerJob(this.jobDetail.getKey());
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    public void shutdown() {
        this.schedulerFacade.releaseJobResource();
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException ex) {
            throw new JobSystemException((Throwable)ex);
        }
    }

    @ConstructorProperties(value={"scheduler", "jobDetail", "schedulerFacade", "triggerIdentity"})
    public JobScheduleController(Scheduler scheduler, JobDetail jobDetail, SchedulerFacade schedulerFacade, String triggerIdentity) {
        this.scheduler = scheduler;
        this.jobDetail = jobDetail;
        this.schedulerFacade = schedulerFacade;
        this.triggerIdentity = triggerIdentity;
    }
}

