/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.schedule;

import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.election.LeaderElectionService;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.listener.ListenerManager;
import com.dangdang.ddframe.job.lite.internal.monitor.MonitorService;
import com.dangdang.ddframe.job.lite.internal.schedule.JobTriggerListener;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.List;

public class SchedulerFacade {
    private final ConfigurationService configService;
    private final LeaderElectionService leaderElectionService;
    private final ServerService serverService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;
    private final MonitorService monitorService;
    private final ListenerManager listenerManager;

    public SchedulerFacade(CoordinatorRegistryCenter regCenter, LiteJobConfiguration liteJobConfig, List<ElasticJobListener> elasticJobListeners) {
        String jobName = liteJobConfig.getJobName();
        this.configService = new ConfigurationService(regCenter, jobName);
        this.leaderElectionService = new LeaderElectionService(regCenter, jobName);
        this.serverService = new ServerService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.monitorService = new MonitorService(regCenter, jobName);
        this.listenerManager = new ListenerManager(regCenter, liteJobConfig, elasticJobListeners);
    }

    public void clearPreviousServerStatus() {
        this.serverService.clearPreviousServerStatus();
    }

    public void registerStartUpInfo(LiteJobConfiguration liteJobConfig) {
        this.listenerManager.startAllListeners();
        this.leaderElectionService.leaderForceElection();
        this.configService.persist(liteJobConfig);
        this.serverService.persistServerOnline(liteJobConfig);
        this.serverService.clearJobPausedStatus();
        this.shardingService.setReshardingFlag();
        this.monitorService.listen();
        this.listenerManager.setCurrentShardingTotalCount(this.configService.load(false).getTypeConfig().getCoreConfig().getShardingTotalCount());
    }

    public void releaseJobResource() {
        this.monitorService.close();
        this.serverService.removeServerStatus();
    }

    public LiteJobConfiguration loadJobConfiguration() {
        return this.configService.load(false);
    }

    public JobTriggerListener newJobTriggerListener() {
        return new JobTriggerListener(this.executionService, this.shardingService);
    }
}

