/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.Pictures;
import com.deepoove.poi.data.style.PictureStyle;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.BufferedImageUtils;
import com.deepoove.poi.util.SVGConvertor;
import com.deepoove.poi.util.UnitUtils;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import com.deepoove.poi.xwpf.WidthScalePattern;
import com.deepoove.poi.xwpf.XWPFRunWrapper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.function.Supplier;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class PictureRenderPolicy
extends AbstractRenderPolicy<Object> {
    @Override
    protected boolean validate(Object data) {
        if (null == data) {
            return false;
        }
        if (data instanceof PictureRenderData) {
            return null != ((PictureRenderData)data).getPictureSupplier();
        }
        return true;
    }

    @Override
    public void doRender(RenderContext<Object> context) throws Exception {
        Helper.renderPicture(context.getRun(), PictureRenderPolicy.wrapper(context.getData()));
    }

    @Override
    protected void afterRender(RenderContext<Object> context) {
        this.clearPlaceholder(context, false);
    }

    @Override
    protected void reThrowException(RenderContext<Object> context, Exception e) {
        this.logger.info("Render picture " + context.getEleTemplate() + " error: {}", (Object)e.getMessage());
        String alt = "";
        if (context.getData() instanceof PictureRenderData) {
            alt = ((PictureRenderData)context.getData()).getAltMeta();
        }
        context.getRun().setText(alt, 0);
    }

    private static PictureRenderData wrapper(Object object) {
        if (object instanceof PictureRenderData) {
            return (PictureRenderData)object;
        }
        return Pictures.of(object.toString()).fitSize().create();
    }

    public static class Helper {
        public static void renderPicture(XWPFRun run, PictureRenderData picture) throws Exception {
            Supplier<byte[]> supplier = picture.getPictureSupplier();
            byte[] imageBytes = supplier.get();
            if (null == imageBytes) {
                throw new IllegalStateException("Can't read picture byte arrays!");
            }
            PictureType pictureType = picture.getPictureType();
            if (null == pictureType) {
                pictureType = PictureType.suggestFileType(imageBytes);
            }
            if (null == pictureType) {
                throw new RenderException("PictureRenderData must set picture type!");
            }
            PictureStyle style = picture.getPictureStyle();
            if (null == style) {
                style = new PictureStyle();
            }
            int width = style.getWidth();
            int height = style.getHeight();
            if (pictureType == PictureType.SVG) {
                imageBytes = SVGConvertor.toPng(imageBytes, width, height);
                pictureType = PictureType.PNG;
            }
            if (!Helper.isSetSize(style)) {
                BodyContainer bodyContainer;
                int pageWidth;
                BufferedImage original = BufferedImageUtils.readBufferedImage(imageBytes);
                width = original.getWidth();
                height = original.getHeight();
                if (style.getScalePattern() == WidthScalePattern.FIT && width > (pageWidth = UnitUtils.twips2Pixel((bodyContainer = BodyContainerFactory.getBodyContainer(((IBodyElement)run.getParent()).getBody())).elementPageWidth((IBodyElement)run.getParent())))) {
                    double ratio = (double)pageWidth / (double)width;
                    width = pageWidth;
                    height = (int)((double)height * ratio);
                }
            }
            try (ByteArrayInputStream stream = new ByteArrayInputStream(imageBytes);){
                PictureStyle.PictureAlign align = style.getAlign();
                if (null != align && run.getParent() instanceof XWPFParagraph) {
                    ((XWPFParagraph)run.getParent()).setAlignment(ParagraphAlignment.valueOf((int)(align.ordinal() + 1)));
                }
                XWPFRunWrapper wrapper = new XWPFRunWrapper(run, false);
                wrapper.addPicture(stream, pictureType.type(), "Generated", Units.pixelToEMU((int)width), Units.pixelToEMU((int)height));
            }
        }

        private static boolean isSetSize(PictureStyle style) {
            return (style.getWidth() != 0 || style.getHeight() != 0) && style.getScalePattern() == WidthScalePattern.NONE;
        }
    }
}

