/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.DocumentRenderData;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.exception.ResolverException;
import com.deepoove.poi.policy.DocumentRenderPolicy;
import com.deepoove.poi.render.DefaultRender;
import com.deepoove.poi.render.Render;
import com.deepoove.poi.resolver.Resolver;
import com.deepoove.poi.resolver.TemplateResolver;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.util.PoitlIOUtils;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWPFTemplate
implements Closeable {
    public static final String TEMPLATE_TAG_NAME = "var";
    private static Logger logger = LoggerFactory.getLogger(XWPFTemplate.class);
    private NiceXWPFDocument doc;
    private Configure config;
    private Resolver resolver;
    private Render renderer;
    private List<MetaTemplate> eleTemplates;

    private XWPFTemplate() {
    }

    public static XWPFTemplate compile(String absolutePath) {
        return XWPFTemplate.compile(new File(absolutePath));
    }

    public static XWPFTemplate compile(File templateFile) {
        return XWPFTemplate.compile(templateFile, Configure.createDefault());
    }

    public static XWPFTemplate compile(InputStream inputStream) {
        return XWPFTemplate.compile(inputStream, Configure.createDefault());
    }

    public static XWPFTemplate compile(XWPFDocument document) {
        return XWPFTemplate.compile(document, Configure.createDefault());
    }

    public static XWPFTemplate compile(String absolutePath, Configure config) {
        return XWPFTemplate.compile(new File(absolutePath), config);
    }

    public static XWPFTemplate compile(File templateFile, Configure config) {
        try {
            return XWPFTemplate.compile(new FileInputStream(templateFile), config);
        }
        catch (FileNotFoundException e) {
            throw new ResolverException("Cannot find the file [" + templateFile.getPath() + "]", e);
        }
    }

    public static XWPFTemplate compile(XWPFDocument document, Configure config) {
        try {
            return XWPFTemplate.compile(PoitlIOUtils.docToInputStream((POIXMLDocument)document), config);
        }
        catch (IOException e) {
            throw new ResolverException("Cannot compile document", e);
        }
    }

    public static XWPFTemplate compile(InputStream inputStream, Configure config) {
        try {
            XWPFTemplate template = new XWPFTemplate();
            template.config = config;
            template.doc = new NiceXWPFDocument(inputStream);
            template.resolver = new TemplateResolver(template.config);
            template.renderer = new DefaultRender();
            template.eleTemplates = template.resolver.resolveDocument(template.doc);
            return template;
        }
        catch (OLE2NotOfficeXmlFileException e) {
            logger.error("Poi-tl currently only supports .docx format");
            throw new ResolverException("Compile template failed", e);
        }
        catch (IOException e) {
            throw new ResolverException("Compile template failed", e);
        }
    }

    public static XWPFTemplate create(DocumentRenderData data) {
        return XWPFTemplate.create(data, null);
    }

    public static XWPFTemplate create(DocumentRenderData data, Style templateTagStyle) {
        Configure configure = Configure.builder().bind(TEMPLATE_TAG_NAME, new DocumentRenderPolicy()).build();
        NiceXWPFDocument document = new NiceXWPFDocument();
        XWPFRun run = document.createParagraph().createRun();
        run.setText(configure.getGramerPrefix() + TEMPLATE_TAG_NAME + configure.getGramerSuffix());
        StyleUtils.styleRun(run, templateTagStyle);
        return XWPFTemplate.compile(document, configure).render(Collections.singletonMap(TEMPLATE_TAG_NAME, data));
    }

    public XWPFTemplate render(Object model) {
        this.renderer.render(this, model);
        return this;
    }

    public XWPFTemplate render(Object model, OutputStream out) throws IOException {
        this.render(model);
        this.write(out);
        return this;
    }

    public void write(OutputStream out) throws IOException {
        this.doc.write(out);
    }

    public void writeAndClose(OutputStream out) throws IOException {
        try {
            this.write(out);
            out.flush();
        }
        catch (Throwable throwable) {
            PoitlIOUtils.closeQuietlyMulti(new Closeable[]{this.doc, out});
            throw throwable;
        }
        PoitlIOUtils.closeQuietlyMulti(new Closeable[]{this.doc, out});
    }

    public void writeToFile(String path) throws IOException {
        this.writeAndClose(new FileOutputStream(path));
    }

    public void reload(NiceXWPFDocument doc) {
        PoitlIOUtils.closeLoggerQuietly((Closeable)((Object)this.doc));
        this.doc = doc;
        this.eleTemplates = this.resolver.resolveDocument(doc);
    }

    @Override
    public void close() throws IOException {
        this.doc.close();
    }

    public List<MetaTemplate> getElementTemplates() {
        return this.eleTemplates;
    }

    public NiceXWPFDocument getXWPFDocument() {
        return this.doc;
    }

    public Configure getConfig() {
        return this.config;
    }

    public Resolver getResolver() {
        return this.resolver;
    }
}

