/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.table;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.compute.EnvModel;
import com.deepoove.poi.render.compute.RenderDataCompute;
import com.deepoove.poi.render.processor.DocumentProcessor;
import com.deepoove.poi.render.processor.EnvIterator;
import com.deepoove.poi.resolver.TemplateResolver;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.ReflectionUtils;
import com.deepoove.poi.util.TableTools;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;

public class MultipleColumnTableRenderPolicy
implements RenderPolicy {
    private static final String DEFAULT_MULTIPLE_PREFIX = "$(";
    private static final String DEFAULT_MULTIPLE_SUFFIX = ")";
    private static final String DEFAULT_PREFIX = "[";
    private static final String DEFAULT_SUFFIX = "]";
    private static final int DEFAULT_MULTIPLE_COLUMN_NUM = 1;
    private final String regex = "\\$\\([0-9]+\\)";
    private final String multiplePrefix;
    private final String multipleSuffix;
    private final String prefix;
    private final String suffix;
    private final boolean onSameLine;

    public MultipleColumnTableRenderPolicy() {
        this(DEFAULT_MULTIPLE_PREFIX, DEFAULT_MULTIPLE_SUFFIX, DEFAULT_PREFIX, DEFAULT_SUFFIX, false);
    }

    public MultipleColumnTableRenderPolicy(boolean onSameLine) {
        this(DEFAULT_MULTIPLE_PREFIX, DEFAULT_MULTIPLE_SUFFIX, DEFAULT_PREFIX, DEFAULT_SUFFIX, onSameLine);
    }

    public MultipleColumnTableRenderPolicy(String prefix, String suffix, boolean onSameLine) {
        this(DEFAULT_MULTIPLE_PREFIX, DEFAULT_MULTIPLE_SUFFIX, prefix, suffix, onSameLine);
    }

    private MultipleColumnTableRenderPolicy(String multiplePrefix, String multipleSuffix, String prefix, String suffix, boolean onSameLine) {
        this.multiplePrefix = multiplePrefix;
        this.multipleSuffix = multipleSuffix;
        this.prefix = prefix;
        this.suffix = suffix;
        this.onSameLine = onSameLine;
    }

    @Override
    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        RunTemplate runTemplate = (RunTemplate)eleTemplate;
        XWPFRun run = runTemplate.getRun();
        try {
            if (!TableTools.isInsideTable(run)) {
                throw new IllegalStateException("The template tag " + runTemplate.getSource() + " must be inside a table");
            }
            XWPFTableCell tagCell = (XWPFTableCell)((XWPFParagraph)run.getParent()).getBody();
            XWPFTableRow tableRow = tagCell.getTableRow();
            XWPFTable table = tableRow.getTable();
            run.setText("", 0);
            int loopColumnNum = this.getLoopColumnNum(tagCell);
            int templateColIndex = this.getTemplateColIndex(tagCell);
            int rowSize = table.getRows().size();
            int index = 0;
            if (data instanceof Iterable) {
                int dataSize = this.getSize((Iterable)data);
                int[] loopColWidths = this.processLoopColWidth(table, tableRow, templateColIndex, dataSize, loopColumnNum);
                int[] newCellInsertPoint4row = new int[rowSize];
                XWPFTableCell[] cursorCell4row = new XWPFTableCell[rowSize];
                boolean initFlag = true;
                TemplateResolver resolver = new TemplateResolver(template.getConfig().copy(this.prefix, this.suffix));
                Iterator iterator = ((Iterable)data).iterator();
                boolean hasNext = iterator.hasNext();
                while (hasNext) {
                    Object root = iterator.next();
                    hasNext = iterator.hasNext();
                    ArrayList<XWPFTableCell> cells = new ArrayList<XWPFTableCell>();
                    int loopCellStartPoint = index * loopColumnNum + templateColIndex;
                    for (int j = 0; j < loopColumnNum * 2; j += 2) {
                        for (int i = 0; i < rowSize; ++i) {
                            XWPFTableRow row = table.getRow(i);
                            int actualLoopCellPosition = this.getActualInsertPosition(row, loopCellStartPoint + j);
                            if (-1 == actualLoopCellPosition) {
                                this.addColGridSpan(row, loopCellStartPoint + j);
                                continue;
                            }
                            XWPFTableCell loopCell = row.getCell(actualLoopCellPosition);
                            if (initFlag) {
                                loopCell.setWidth(String.valueOf(loopColWidths[j / 2]));
                                if (j == 0) {
                                    cursorCell4row[i] = loopCell;
                                    newCellInsertPoint4row[i] = actualLoopCellPosition;
                                }
                            }
                            this.insertCell(row, newCellInsertPoint4row[i]);
                            this.setTableCell(row, loopCell, newCellInsertPoint4row[i]);
                            XmlCursor newCursor = cursorCell4row[i].getCTTc().newCursor();
                            newCursor.toPrevSibling();
                            XmlObject object = newCursor.getObject();
                            XWPFTableCell nextCell = new XWPFTableCell((CTTc)object, row, (IBody)loopCell.getPart());
                            int n = i;
                            int n2 = newCellInsertPoint4row[n];
                            newCellInsertPoint4row[n] = n2 + 1;
                            this.setTableCell(row, nextCell, n2);
                            cells.add(nextCell);
                        }
                    }
                    initFlag = false;
                    RenderDataCompute dataCompute = template.getConfig().getRenderDataComputeFactory().newCompute(EnvModel.of(root, EnvIterator.makeEnv(index++, hasNext)));
                    cells.forEach(cell -> {
                        List<MetaTemplate> templates = resolver.resolveBodyElements(cell.getBodyElements());
                        new DocumentProcessor(template, resolver, dataCompute).process(templates);
                    });
                }
            }
            int endPoint = index * loopColumnNum + templateColIndex - 1;
            for (int j = loopColumnNum; j > 0; --j) {
                for (int i = 0; i < rowSize; ++i) {
                    XWPFTableRow row = table.getRow(i);
                    int actualInsertPosition = this.getActualInsertPosition(row, endPoint + j);
                    if (-1 == actualInsertPosition) {
                        this.minusGridSpan(row, endPoint + j);
                        continue;
                    }
                    this.removeCell(row, actualInsertPosition);
                }
            }
            this.afterloop(table, data);
        }
        catch (Exception e) {
            throw new RenderException("failed to render table multi-column template", e);
        }
    }

    protected int getLoopColumnNum(XWPFTableCell tagCell) {
        int loopColumnNum = 1;
        String text = tagCell.getText();
        Matcher matcher = Pattern.compile("\\$\\([0-9]+\\)").matcher(text);
        if (matcher.find()) {
            String rowNumText = matcher.group(0);
            loopColumnNum = Integer.parseInt(rowNumText.replace(this.multiplePrefix, "").replace(this.multipleSuffix, ""));
            List paragraphs = tagCell.getParagraphs();
            ((XWPFRun)((XWPFParagraph)paragraphs.get(0)).getRuns().get(0)).setText(text.replace(rowNumText, ""), 0);
            Iterator paragraphsIt = paragraphs.iterator();
            boolean isFirstParagraph = true;
            boolean hasNext = paragraphsIt.hasNext();
            while (hasNext) {
                XWPFParagraph nextParagraph = (XWPFParagraph)paragraphsIt.next();
                hasNext = paragraphsIt.hasNext();
                for (int i = 0; i < nextParagraph.getRuns().size(); ++i) {
                    if (isFirstParagraph) {
                        isFirstParagraph = false;
                        continue;
                    }
                    ((XWPFRun)nextParagraph.getRuns().get(i)).setText("", 0);
                }
            }
        }
        return loopColumnNum;
    }

    private int getTemplateColIndex(XWPFTableCell tagCell) {
        return this.onSameLine ? this.getColIndex(tagCell) : this.getColIndex(tagCell) + 1;
    }

    private void minusGridSpan(XWPFTableRow row, int templateColIndex) {
        XWPFTableCell actualCell = this.getActualCell(row, templateColIndex);
        CTTcPr tcPr = actualCell.getCTTc().getTcPr();
        CTDecimalNumber gridSpan = tcPr.getGridSpan();
        gridSpan.setVal(BigInteger.valueOf(gridSpan.getVal().longValue() - 1L));
    }

    private void addColGridSpan(XWPFTableRow row, int insertPosition) {
        XWPFTableCell actualCell = this.getActualCell(row, insertPosition);
        CTTcPr tcPr = actualCell.getCTTc().getTcPr();
        CTDecimalNumber gridSpan = tcPr.getGridSpan();
        gridSpan.setVal(BigInteger.valueOf(gridSpan.getVal().longValue() + 1L));
    }

    private int[] processLoopColWidth(XWPFTable table, XWPFTableRow row, int templateColIndex, int dataSize, int loopColumnNum) {
        int i;
        int[] loopColWidths = new int[loopColumnNum];
        CTTblGrid tblGrid = TableTools.getTblGrid(table);
        for (i = 0; i < loopColumnNum; ++i) {
            int colWidth;
            int actualColIndex = this.getActualInsertPosition(row, templateColIndex + i);
            XWPFTableCell templateCell = row.getCell(actualColIndex);
            int width = templateCell.getWidth();
            TableWidthType widthType = templateCell.getWidthType();
            if (TableWidthType.DXA != widthType || width == 0) {
                throw new IllegalArgumentException("template col must set width in centimeters.");
            }
            loopColWidths[i] = colWidth = width / dataSize;
        }
        for (i = 0; i < dataSize; ++i) {
            for (int j = 0; j < loopColumnNum; ++j) {
                CTTblGridCol newGridCol = tblGrid.insertNewGridCol(templateColIndex + j + i * loopColumnNum);
                newGridCol.setW((Object)BigInteger.valueOf(loopColWidths[j]));
            }
        }
        for (i = loopColumnNum * dataSize + loopColumnNum + (templateColIndex - 1); i >= loopColumnNum * dataSize + 1 + (templateColIndex - 1); --i) {
            tblGrid.removeGridCol(i);
        }
        return loopColWidths;
    }

    private int getSize(Iterable<?> data) {
        int size = 0;
        for (Object datum : data) {
            ++size;
        }
        return size;
    }

    private void removeCell(XWPFTableRow row, int actualInsertPosition) {
        List cells = (List)ReflectionUtils.getValue("tableCells", row);
        cells.remove(actualInsertPosition);
        row.getCtRow().removeTc(actualInsertPosition);
    }

    private XWPFTableCell insertCell(XWPFTableRow tableRow, int actualInsertPosition) {
        CTRow row = tableRow.getCtRow();
        CTTc newTc = row.insertNewTc(actualInsertPosition);
        XWPFTableCell cell = new XWPFTableCell(newTc, tableRow, tableRow.getTable().getBody());
        List cells = (List)ReflectionUtils.getValue("tableCells", tableRow);
        cells.add(actualInsertPosition, cell);
        return cell;
    }

    protected void afterloop(XWPFTable table, Object data) {
    }

    private void setTableCell(XWPFTableRow row, XWPFTableCell templateCell, int pos) {
        List rows = (List)ReflectionUtils.getValue("tableCells", row);
        rows.set(pos, templateCell);
        row.getCtRow().setTcArray(pos, templateCell.getCTTc());
    }

    private int getColIndex(XWPFTableCell cell) {
        XWPFTableRow tableRow = cell.getTableRow();
        int orginalCol = 0;
        for (int i = 0; i < tableRow.getTableCells().size(); ++i) {
            CTDecimalNumber gridSpan;
            XWPFTableCell current = tableRow.getCell(i);
            int intValue = 1;
            CTTcPr tcPr = current.getCTTc().getTcPr();
            if (null != tcPr && null != (gridSpan = tcPr.getGridSpan())) {
                intValue = gridSpan.getVal().intValue();
            }
            orginalCol += intValue;
            if (current.getCTTc() != cell.getCTTc()) continue;
            return orginalCol - intValue;
        }
        return -1;
    }

    private int getActualInsertPosition(XWPFTableRow tableRow, int insertPosition) {
        int orginalCol = 0;
        for (int i = 0; i < tableRow.getTableCells().size(); ++i) {
            CTDecimalNumber gridSpan;
            XWPFTableCell current = tableRow.getCell(i);
            int intValue = 1;
            CTTcPr tcPr = current.getCTTc().getTcPr();
            if (null != tcPr && null != (gridSpan = tcPr.getGridSpan())) {
                intValue = gridSpan.getVal().intValue();
            }
            if ((orginalCol += intValue) - intValue != insertPosition || intValue != 1) continue;
            return i;
        }
        return -1;
    }

    private XWPFTableCell getActualCell(XWPFTableRow tableRow, int insertPosition) {
        int orginalCol = 0;
        for (int i = 0; i < tableRow.getTableCells().size(); ++i) {
            CTDecimalNumber gridSpan;
            XWPFTableCell current = tableRow.getCell(i);
            int intValue = 1;
            CTTcPr tcPr = current.getCTTc().getTcPr();
            if (null != tcPr && null != (gridSpan = tcPr.getGridSpan())) {
                intValue = gridSpan.getVal().intValue();
            }
            if ((orginalCol += intValue) - 1 < insertPosition) continue;
            return current;
        }
        return null;
    }
}

