/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.render;

import com.deepoove.poi.converter.ObjectToTextRenderDataConverter;
import com.deepoove.poi.converter.ToRenderDataConverter;
import com.deepoove.poi.data.NumberingRenderData;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.TableRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.NumberingRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.TableRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class WhereDelegate {
    private static final ToRenderDataConverter<Object, TextRenderData> converter = new ObjectToTextRenderDataConverter();
    private final XWPFRun run;

    public WhereDelegate(XWPFRun run) {
        this.run = run;
    }

    public XWPFRun getRun() {
        return this.run;
    }

    public void renderText(Object data) throws Exception {
        TextRenderData renderData = converter.convert(data);
        TextRenderPolicy.Helper.renderTextRun(this.run, renderData);
    }

    public void renderNumbering(NumberingRenderData data) throws Exception {
        NumberingRenderPolicy.Helper.renderNumbering(this.run, data);
    }

    public void renderPicture(PictureRenderData data) throws Exception {
        PictureRenderPolicy.Helper.renderPicture(this.run, data);
    }

    public void renderTable(TableRenderData data) throws Exception {
        TableRenderPolicy.Helper.renderTable(this.run, data);
    }

    public void addPicture(InputStream inputStream, int type, int width, int height) throws InvalidFormatException, IOException {
        this.run.addPicture(inputStream, type, "Generated", Units.pixelToEMU((int)width), Units.pixelToEMU((int)height));
    }
}

