/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import com.ecfront.dew.common.$;
import com.ecfront.dew.common.HttpHelper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.joox.JOOX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ApacheHttpHelper
implements HttpHelper {
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpHelper.class);
    private CloseableHttpClient httpClient;
    private boolean retryAble;
    private int defaultConnectTimeoutMS;
    private int defaultSocketTimeoutMS;

    ApacheHttpHelper(int maxTotal, int maxPerRoute, int defaultConnectTimeoutMS, int defaultSocketTimeoutMS, Boolean autoRedirect, boolean retryAble) {
        this.defaultConnectTimeoutMS = defaultConnectTimeoutMS;
        this.defaultSocketTimeoutMS = defaultSocketTimeoutMS;
        this.retryAble = retryAble;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        httpClientBuilder.setSSLContext(sslContext);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connMgr.setMaxTotal(maxTotal);
        connMgr.setDefaultMaxPerRoute(maxPerRoute);
        if (autoRedirect.booleanValue()) {
            httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        }
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connMgr);
        this.httpClient = httpClientBuilder.build();
    }

    @Override
    public String get(String url) throws IOException {
        return this.get(url, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String get(String url, Map<String, String> header) throws IOException {
        return this.get(url, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String get(String url, String contentType) throws IOException {
        return this.get(url, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String get(String url, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request((String)"GET", (String)url, null, header, (String)contentType, (String)charset, (int)connectTimeoutMS, (int)socketTimeoutMS).result;
    }

    @Override
    public HttpHelper.ResponseWrap getWrap(String url) throws IOException {
        return this.getWrap(url, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap getWrap(String url, Map<String, String> header) throws IOException {
        return this.getWrap(url, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap getWrap(String url, String contentType) throws IOException {
        return this.getWrap(url, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap getWrap(String url, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request("GET", url, null, header, contentType, charset, connectTimeoutMS, socketTimeoutMS);
    }

    @Override
    public String post(String url, Object body) throws IOException {
        return this.post(url, body, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String post(String url, Object body, Map<String, String> header) throws IOException {
        return this.post(url, body, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String post(String url, Object body, String contentType) throws IOException {
        return this.post(url, body, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String post(String url, Object body, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request((String)"POST", (String)url, (Object)body, header, (String)contentType, (String)charset, (int)connectTimeoutMS, (int)socketTimeoutMS).result;
    }

    @Override
    public HttpHelper.ResponseWrap postWrap(String url, Object body) throws IOException {
        return this.postWrap(url, body, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap postWrap(String url, Object body, Map<String, String> header) throws IOException {
        return this.postWrap(url, body, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap postWrap(String url, Object body, String contentType) throws IOException {
        return this.postWrap(url, body, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap postWrap(String url, Object body, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request("POST", url, body, header, contentType, charset, connectTimeoutMS, socketTimeoutMS);
    }

    @Override
    public String put(String url, Object body) throws IOException {
        return this.put(url, body, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String put(String url, Object body, Map<String, String> header) throws IOException {
        return this.put(url, body, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String put(String url, Object body, String contentType) throws IOException {
        return this.put(url, body, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String put(String url, Object body, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request((String)"PUT", (String)url, (Object)body, header, (String)contentType, (String)charset, (int)connectTimeoutMS, (int)socketTimeoutMS).result;
    }

    @Override
    public HttpHelper.ResponseWrap putWrap(String url, Object body) throws IOException {
        return this.putWrap(url, body, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap putWrap(String url, Object body, Map<String, String> header) throws IOException {
        return this.putWrap(url, body, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap putWrap(String url, Object body, String contentType) throws IOException {
        return this.putWrap(url, body, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap putWrap(String url, Object body, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request("PUT", url, body, header, contentType, charset, connectTimeoutMS, socketTimeoutMS);
    }

    @Override
    public String patch(String url, Object body) throws IOException {
        return this.patch(url, body, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String patch(String url, Object body, Map<String, String> header) throws IOException {
        return this.patch(url, body, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String patch(String url, Object body, String contentType) throws IOException {
        return this.patch(url, body, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String patch(String url, Object body, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request((String)"PATCH", (String)url, (Object)body, header, (String)contentType, (String)charset, (int)connectTimeoutMS, (int)socketTimeoutMS).result;
    }

    @Override
    public HttpHelper.ResponseWrap patchWrap(String url, Object body) throws IOException {
        return this.patchWrap(url, body, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap patchWrap(String url, Object body, Map<String, String> header) throws IOException {
        return this.patchWrap(url, body, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap patchWrap(String url, Object body, String contentType) throws IOException {
        return this.patchWrap(url, body, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap patchWrap(String url, Object body, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request("PATCH", url, body, header, contentType, charset, connectTimeoutMS, socketTimeoutMS);
    }

    @Override
    public String delete(String url) throws IOException {
        return this.delete(url, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String delete(String url, Map<String, String> header) throws IOException {
        return this.delete(url, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String delete(String url, String contentType) throws IOException {
        return this.delete(url, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public String delete(String url, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request((String)"DELETE", (String)url, null, header, (String)contentType, (String)charset, (int)connectTimeoutMS, (int)socketTimeoutMS).result;
    }

    @Override
    public HttpHelper.ResponseWrap deleteWrap(String url) throws IOException {
        return this.deleteWrap(url, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap deleteWrap(String url, Map<String, String> header) throws IOException {
        return this.deleteWrap(url, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap deleteWrap(String url, String contentType) throws IOException {
        return this.deleteWrap(url, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public HttpHelper.ResponseWrap deleteWrap(String url, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request("DELETE", url, null, header, contentType, charset, connectTimeoutMS, socketTimeoutMS);
    }

    @Override
    public Map<String, List<String>> head(String url) throws IOException {
        return this.head(url, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public Map<String, List<String>> head(String url, Map<String, String> header) throws IOException {
        return this.head(url, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public Map<String, List<String>> head(String url, String contentType) throws IOException {
        return this.head(url, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public Map<String, List<String>> head(String url, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request((String)"HEAD", (String)url, null, header, (String)contentType, (String)charset, (int)connectTimeoutMS, (int)socketTimeoutMS).head;
    }

    @Override
    public Map<String, List<String>> options(String url) throws IOException {
        return this.options(url, null, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public Map<String, List<String>> options(String url, Map<String, String> header) throws IOException {
        return this.options(url, header, null, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public Map<String, List<String>> options(String url, String contentType) throws IOException {
        return this.options(url, null, contentType, null, this.defaultConnectTimeoutMS, this.defaultSocketTimeoutMS);
    }

    @Override
    public Map<String, List<String>> options(String url, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request((String)"OPTIONS", (String)url, null, header, (String)contentType, (String)charset, (int)connectTimeoutMS, (int)socketTimeoutMS).head;
    }

    @Override
    public HttpHelper.ResponseWrap request(String method, String url, Object body, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS) throws IOException {
        return this.request(method, url, body, header, contentType, charset, connectTimeoutMS, socketTimeoutMS, 0);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpHelper.ResponseWrap request(String method, String url, Object body, Map<String, String> header, String contentType, String charset, int connectTimeoutMS, int socketTimeoutMS, int retry) throws IOException {
        HttpGet httpMethod;
        void var12_22;
        if (header == null) {
            header = new HashMap<String, String>();
        }
        if (body != null && body instanceof File) {
            contentType = "multipart/form-data";
        } else if (contentType == null) {
            contentType = "application/json; charset=utf-8";
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        String string = method.toUpperCase();
        int n = -1;
        switch (string.hashCode()) {
            case 70454: {
                if (!string.equals("GET")) break;
                boolean bl = false;
                break;
            }
            case 2461856: {
                if (!string.equals("POST")) break;
                boolean bl = true;
                break;
            }
            case 79599: {
                if (!string.equals("PUT")) break;
                int n2 = 2;
                break;
            }
            case 2012838315: {
                if (!string.equals("DELETE")) break;
                int n3 = 3;
                break;
            }
            case 2213344: {
                if (!string.equals("HEAD")) break;
                int n4 = 4;
                break;
            }
            case -531492226: {
                if (!string.equals("OPTIONS")) break;
                int n5 = 5;
                break;
            }
            case 80083237: {
                if (!string.equals("TRACE")) break;
                int n6 = 6;
                break;
            }
            case 75900968: {
                if (!string.equals("PATCH")) break;
                int n7 = 7;
                break;
            }
        }
        switch (var12_22) {
            case 0: {
                httpMethod = new HttpGet(url);
                break;
            }
            case 1: {
                httpMethod = new HttpPost(url);
                break;
            }
            case 2: {
                httpMethod = new HttpPut(url);
                break;
            }
            case 3: {
                httpMethod = new HttpDelete(url);
                break;
            }
            case 4: {
                httpMethod = new HttpHead(url);
                break;
            }
            case 5: {
                httpMethod = new HttpOptions(url);
                break;
            }
            case 6: {
                httpMethod = new HttpTrace(url);
                break;
            }
            case 7: {
                httpMethod = new HttpPatch(url);
                break;
            }
            default: {
                throw new RuntimeException("The method [" + method + "] is NOT exist.");
            }
        }
        httpMethod.setConfig(RequestConfig.custom().setSocketTimeout(socketTimeoutMS).setConnectTimeout(connectTimeoutMS).build());
        for (Map.Entry entry : header.entrySet()) {
            httpMethod.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (contentType != null) {
            httpMethod.addHeader("Content-Type", contentType);
        }
        logger.trace("HTTP [" + method + "]" + url);
        if (body != null) {
            StringEntity entity;
            switch (contentType.toLowerCase()) {
                case "application/x-www-form-urlencoded": {
                    String[] items;
                    ArrayList<BasicNameValuePair> m = new ArrayList<BasicNameValuePair>();
                    if (body instanceof Map) {
                        ((Map)body).forEach((key, value) -> m.add(new BasicNameValuePair(key, value)));
                        entity = new UrlEncodedFormEntity(m, charset);
                        break;
                    }
                    if (!(body instanceof String)) throw new IllegalArgumentException("The body nly support Map OR String types when content type is application/x-www-form-urlencoded");
                    for (String item : items = URLDecoder.decode((String)body, charset).split("&")) {
                        String[] kv = item.split("=");
                        m.add(new BasicNameValuePair(kv[0], kv.length == 2 ? kv[1] : ""));
                    }
                    entity = new UrlEncodedFormEntity(m, charset);
                    break;
                }
                case "xml": {
                    if (body instanceof Document) {
                        entity = new StringEntity(JOOX.$((Document)((Document)body)).toString(), charset);
                        break;
                    }
                    if (body instanceof String) {
                        entity = new StringEntity((String)body, charset);
                        break;
                    }
                    logger.error("Not support return type [" + body.getClass().getName() + "] by xml");
                    entity = new StringEntity("", charset);
                    break;
                }
                case "multipart/form-data": {
                    httpMethod.addHeader("Content-Transfer-Encoding", "binary");
                    entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody(((File)body).getName(), (File)body, ContentType.APPLICATION_OCTET_STREAM, ((File)body).getName()).build();
                    httpMethod.removeHeaders("Content-Type");
                    break;
                }
                default: {
                    entity = body instanceof String ? new StringEntity((String)body, charset) : (body instanceof Integer || body instanceof Long || body instanceof Float || body instanceof Double || body instanceof BigDecimal || body instanceof Boolean ? new StringEntity(body.toString(), charset) : (body instanceof Date ? new StringEntity(((Date)body).getTime() + "", charset) : new StringEntity($.json.toJsonString(body), charset)));
                }
            }
            ((HttpEntityEnclosingRequestBase)httpMethod).setEntity((HttpEntity)entity);
        }
        try {
            Throwable throwable = null;
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpMethod);){
                HttpHelper.ResponseWrap responseWrap2 = new HttpHelper.ResponseWrap();
                responseWrap2.result = !(httpMethod instanceof HttpHead) && !(httpMethod instanceof HttpOptions) ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)charset) : "";
                responseWrap2.statusCode = response.getStatusLine().getStatusCode();
                String finalCharset = charset;
                responseWrap2.head = Arrays.stream(response.getAllHeaders()).collect(Collectors.groupingBy(head -> head.getName())).entrySet().stream().collect(Collectors.toMap(head -> (String)head.getKey(), arg_0 -> ApacheHttpHelper.lambda$request$6(finalCharset, (HttpRequestBase)httpMethod, url, arg_0)));
                HttpHelper.ResponseWrap responseWrap = responseWrap2;
                return responseWrap;
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throw throwable3;
            }
        }
        catch (ConnectException | UnknownHostException | ConnectTimeoutException e) {
            if (this.retryAble && retry <= 5) {
                try {
                    Thread.sleep(1000 * retry);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    interruptedException.printStackTrace();
                }
                logger.warn("HTTP [" + httpMethod.getMethod() + "] " + url + " ERROR. retry " + (retry + 1) + ".");
                return this.request(method, url, body, header, contentType, charset, connectTimeoutMS, socketTimeoutMS, retry + 1);
            }
            logger.warn("HTTP [" + httpMethod.getMethod() + "] " + url + " ERROR. retry " + (retry + 1) + ".");
            throw e;
        }
        catch (IOException e) {
            logger.warn("HTTP [" + httpMethod.getMethod() + "] " + url + " ERROR. retry " + (retry + 1) + ".");
            throw e;
        }
    }

    private static /* synthetic */ List lambda$request$6(String string, HttpRequestBase httpRequestBase, String string2, Map.Entry head) {
        return ((List)head.getValue()).stream().map(h -> {
            try {
                return URLDecoder.decode(h.getValue(), string);
            }
            catch (UnsupportedEncodingException e) {
                logger.warn("HTTP [" + httpRequestBase.getMethod() + "] " + string2 + " ERROR ", (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
    }
}

