/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import com.ecfront.dew.common.DependencyHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtilsBean;

public class BeanHelper {
    private NullAwareBeanUtilsBean copyPropertiesAdapter;
    private boolean useCache = true;
    private static final Map<String, Map<String, Field>> FIELDS = new WeakHashMap<String, Map<String, Field>>();
    private static final Map<String, List<Method>> METHODS = new WeakHashMap<String, List<Method>>();

    BeanHelper() {
        if (DependencyHelper.hasDependency("org.apache.commons.beanutils.BeanUtilsBean")) {
            this.useCache = true;
            this.copyPropertiesAdapter = new NullAwareBeanUtilsBean();
        }
    }

    BeanHelper(boolean useCache) {
        this.useCache = useCache;
    }

    public void copyProperties(Object dest, Object ori) throws InvocationTargetException, IllegalAccessException {
        this.copyPropertiesAdapter.copyProperties(dest, ori);
    }

    public <T> T copyProperties(Object ori, Class<T> destClazz) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        T dest = destClazz.newInstance();
        this.copyProperties(dest, ori);
        return dest;
    }

    public <T extends Annotation> T getClassAnnotation(Class<?> clazz, Class<T> annotationClass) {
        return clazz.getAnnotation(annotationClass);
    }

    public Map<String, FieldInfo> findFieldsInfo(Class<?> clazz, Set<String> excludeNames, Set<Class<? extends Annotation>> excludeAnnotationClasses, Set<String> includeNames, Set<Class<? extends Annotation>> includeAnnotationClasses) {
        HashMap<String, FieldInfo> fieldsInfo = new HashMap<String, FieldInfo>();
        if (excludeNames == null) {
            excludeNames = new HashSet<String>();
        }
        if (excludeAnnotationClasses == null) {
            excludeAnnotationClasses = new HashSet<Class<? extends Annotation>>();
        }
        if (includeNames == null) {
            includeNames = new HashSet<String>();
        }
        if (includeAnnotationClasses == null) {
            includeAnnotationClasses = new HashSet<Class<? extends Annotation>>();
        }
        Set<String> finalExcludeNames = excludeNames;
        Set<Class<? extends Annotation>> finalExcludeAnnotationClasses = excludeAnnotationClasses;
        Set<String> finalIncludeNames = includeNames;
        Set<Class<? extends Annotation>> finalIncludeAnnotationClasses = includeAnnotationClasses;
        this.getFields(clazz).values().stream().filter(f -> !finalExcludeNames.contains(f.getName())).filter(f -> finalExcludeAnnotationClasses.stream().noneMatch(ann -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).collect(Collectors.toSet()).contains(ann))).filter(f -> finalIncludeNames.isEmpty() || finalIncludeNames.contains(f.getName())).filter(f -> finalIncludeAnnotationClasses.isEmpty() || finalIncludeAnnotationClasses.stream().anyMatch(ann -> Arrays.stream(f.getAnnotations()).map(Annotation::annotationType).collect(Collectors.toSet()).contains(ann))).forEach(field -> {
            FieldInfo info = new FieldInfo();
            info.setName(field.getName());
            info.setType(field.getType());
            info.setAnnotations(new HashSet<Annotation>(Arrays.asList(field.getAnnotations())));
            info.setField((Field)field);
            fieldsInfo.put(field.getName(), info);
        });
        return fieldsInfo;
    }

    public Map<String, Field> getFields(Class<?> clazz) {
        Map fields = FIELDS.getOrDefault(clazz.getName(), new HashMap());
        if (!fields.isEmpty()) {
            return fields;
        }
        for (Field field : clazz.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            fields.putAll(this.getFields(clazz.getSuperclass()));
        }
        if (this.useCache) {
            FIELDS.put(clazz.getName(), fields);
        }
        return fields;
    }

    public List<MethodInfo> findMethodsInfo(Class<?> clazz, Set<String> excludeNames, Set<Class<? extends Annotation>> excludeAnnotationClasses, Set<String> includeNames, Set<Class<? extends Annotation>> includeAnnotationClasses) {
        ArrayList<MethodInfo> methodsInfo = new ArrayList<MethodInfo>();
        if (excludeNames == null) {
            excludeNames = new HashSet<String>();
        }
        if (excludeAnnotationClasses == null) {
            excludeAnnotationClasses = new HashSet<Class<? extends Annotation>>();
        }
        if (includeNames == null) {
            includeNames = new HashSet<String>();
        }
        if (includeAnnotationClasses == null) {
            includeAnnotationClasses = new HashSet<Class<? extends Annotation>>();
        }
        Set<String> finalExcludeNames = excludeNames;
        Set<Class<? extends Annotation>> finalExcludeAnnotationClasses = excludeAnnotationClasses;
        Set<String> finalIncludeNames = includeNames;
        Set<Class<? extends Annotation>> finalIncludeAnnotationClasses = includeAnnotationClasses;
        this.getMethods(clazz).stream().filter(m -> !finalExcludeNames.contains(m.getName())).filter(m -> finalExcludeAnnotationClasses.stream().noneMatch(ann -> Arrays.stream(m.getAnnotations()).map(Annotation::annotationType).collect(Collectors.toSet()).contains(ann))).filter(m -> finalIncludeNames.isEmpty() || finalIncludeNames.contains(m.getName())).filter(m -> finalIncludeAnnotationClasses.isEmpty() || finalIncludeAnnotationClasses.stream().anyMatch(ann -> Arrays.stream(m.getAnnotations()).map(Annotation::annotationType).collect(Collectors.toSet()).contains(ann))).forEach(method -> {
            MethodInfo info = new MethodInfo();
            info.setName(method.getName());
            info.setReturnType(method.getReturnType());
            info.setAnnotations(new HashSet<Annotation>(Arrays.asList(method.getAnnotations())));
            info.setMethod((Method)method);
            methodsInfo.add(info);
        });
        return methodsInfo;
    }

    public List<Method> getMethods(Class<?> clazz) {
        List methods = METHODS.getOrDefault(clazz.getName(), new ArrayList());
        if (!methods.isEmpty()) {
            return methods;
        }
        methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            methods.addAll(this.getMethods(clazz.getSuperclass()));
        }
        if (this.useCache) {
            METHODS.put(clazz.getName(), methods);
        }
        return methods;
    }

    public Map<String, Method[]> parseRelFieldAndMethod(Class<?> clazz, Set<String> excludeNames, Set<Class<? extends Annotation>> excludeAnnotationClasses, Set<String> includeNames, Set<Class<? extends Annotation>> includeAnnotationClasses) throws NoSuchMethodException {
        HashMap<String, Method[]> rel = new HashMap<String, Method[]>();
        Map<String, FieldInfo> fieldsInfo = this.findFieldsInfo(clazz, excludeNames, excludeAnnotationClasses, includeNames, includeAnnotationClasses);
        for (Map.Entry<String, FieldInfo> info : fieldsInfo.entrySet()) {
            rel.put(info.getKey(), new Method[]{clazz.getMethod(this.packageMethodNameByField(info.getValue().getField(), false), new Class[0]), clazz.getMethod(this.packageMethodNameByField(info.getValue().getField(), true), info.getValue().getType())});
        }
        return rel;
    }

    public Map<String, Object> findValuesByRel(Object obj, Map<String, Method[]> relFieldAndMethod) throws InvocationTargetException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, Method[]> rel : relFieldAndMethod.entrySet()) {
            values.put(rel.getKey(), this.getValue(obj, rel.getValue()[0]));
        }
        return values;
    }

    public Map<String, Object> findValues(Object obj, Map<String, FieldInfo> fieldsInfo) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, FieldInfo> info : fieldsInfo.entrySet()) {
            values.put(info.getKey(), this.getValue(obj, info.getValue().getField()));
        }
        return values;
    }

    public Map<String, Object> findValues(Object obj, Set<String> excludeNames, Set<Class<? extends Annotation>> excludeAnnotationClasses, Set<String> includeNames, Set<Class<? extends Annotation>> includeAnnotationClasses) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        this.findFieldsInfo(obj.getClass(), excludeNames, excludeAnnotationClasses, includeNames, includeAnnotationClasses).forEach((k, v) -> values.put((String)k, this.getValue(obj, v.getField())));
        return values;
    }

    public Object getValue(Object obj, Method method) throws InvocationTargetException {
        return this.invoke(obj, method, new Object[0]);
    }

    public Object getValue(Object obj, String fieldName) throws NoSuchFieldException {
        Map<String, Field> fields = this.getFields(obj.getClass());
        if (fields.containsKey(fieldName)) {
            return this.getValue(obj, fields.get(fieldName));
        }
        throw new NoSuchFieldException();
    }

    public Object getValue(Object obj, Field field) {
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setValue(Object obj, Method method, Object value) throws InvocationTargetException {
        this.invoke(obj, method, value);
    }

    public void setValue(Object obj, String fieldName, Object value) throws NoSuchFieldException {
        Map<String, Field> fields = this.getFields(obj.getClass());
        if (!fields.containsKey(fieldName)) {
            throw new NoSuchFieldException();
        }
        this.setValue(obj, fields.get(fieldName), value);
    }

    public void setValue(Object obj, Field field, Object value) {
        field.setAccessible(true);
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public Object invoke(Object obj, Method method, Object ... args) throws InvocationTargetException {
        method.setAccessible(true);
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String packageMethodNameByField(Field field, boolean isSet) {
        if (isSet) {
            Character c;
            if (field.getType() == Boolean.TYPE && field.getName().startsWith("is") && field.getName().length() > 3 && (c = Character.valueOf(field.getName().substring(2, 1).toCharArray()[0])).charValue() >= 'A' && c.charValue() <= 'Z') {
                return "set" + field.getName().substring(2);
            }
            return "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        }
        if (field.getType() == Boolean.TYPE) {
            Character c;
            if (field.getName().startsWith("is") && field.getName().length() > 3 && (c = Character.valueOf(field.getName().substring(2, 1).toCharArray()[0])).charValue() >= 'A' && c.charValue() <= 'Z') {
                return field.getName();
            }
            return "is" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        }
        return "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    public static class MethodInfo {
        private String name;
        private Class<?> returnType;
        private Set<Annotation> annotations;
        private Method method;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public void setReturnType(Class<?> returnType) {
            this.returnType = returnType;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Set<Annotation> annotations) {
            this.annotations = annotations;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }

    public static class FieldInfo {
        private String name;
        private Class<?> type;
        private Set<Annotation> annotations;
        private Field field;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Set<Annotation> annotations) {
            this.annotations = annotations;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }
    }

    static class NullAwareBeanUtilsBean
    extends BeanUtilsBean {
        NullAwareBeanUtilsBean() {
        }

        public void copyProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
            if (null != value) {
                super.copyProperty(bean, name, value);
            }
        }
    }
}

