/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FallbackHelper {
    private static final Map<String, FallbackInfo> CONTAINER = new ConcurrentHashMap<String, FallbackInfo>();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss SSS");

    public FallbackInfo getFallbackInfo(String groupName) {
        return CONTAINER.getOrDefault(groupName, new FallbackInfo());
    }

    public <E> E execute(String groupName, NormalProcessor normalProcessor, ErrorProcessor errorProcessor) {
        return this.execute(groupName, normalProcessor, errorProcessor, (FallbackStrategy)new DefaultFallbackStrategy(), new ArrayList<Class<? extends Throwable>>());
    }

    public <E> E execute(String groupName, NormalProcessor normalProcessor, ErrorProcessor errorProcessor, FallbackStrategy fallbackStrategy) {
        return this.execute(groupName, normalProcessor, errorProcessor, fallbackStrategy, new ArrayList<Class<? extends Throwable>>());
    }

    public <E> E execute(String groupName, NormalProcessor normalProcessor, ErrorProcessor errorProcessor, Class<? extends Throwable> ... excludeFallbackErrors) {
        return this.execute(groupName, normalProcessor, errorProcessor, (FallbackStrategy)new DefaultFallbackStrategy(), Arrays.asList(excludeFallbackErrors));
    }

    public <E> E execute(String groupName, NormalProcessor normalProcessor, ErrorProcessor errorProcessor, FallbackStrategy fallbackStrategy, Class<? extends Throwable> ... excludeFallbackErrors) {
        return this.execute(groupName, normalProcessor, errorProcessor, fallbackStrategy, Arrays.asList(excludeFallbackErrors));
    }

    private <E> E execute(String groupName, NormalProcessor normalProcessor, ErrorProcessor errorProcessor, FallbackStrategy fallbackStrategy, List<Class<? extends Throwable>> excludeFallbackErrors) {
        CONTAINER.putIfAbsent(groupName, new FallbackInfo());
        FallbackInfo fallbackInfo = CONTAINER.get(groupName);
        fallbackInfo.request();
        if (fallbackStrategy.check(fallbackInfo)) {
            try {
                Object result = normalProcessor.execute();
                fallbackInfo.success();
                return result;
            }
            catch (Throwable e) {
                if (!excludeFallbackErrors.contains(e.getClass())) {
                    fallbackInfo.error();
                    return errorProcessor.execute(e, fallbackInfo);
                }
                fallbackInfo.success();
                throw new RuntimeException(e);
            }
        }
        return errorProcessor.execute(new FallbackException(String.format("%s has %s errors , last success is %s", groupName, fallbackInfo.getErrorTimes(), fallbackInfo.getLastGreenTime().format(DATE_TIME_FORMATTER))), fallbackInfo);
    }

    @FunctionalInterface
    public static interface NormalProcessor<E> {
        public E execute() throws Throwable;
    }

    @FunctionalInterface
    public static interface ErrorProcessor<E> {
        public E execute(Throwable var1, FallbackInfo var2);
    }

    public static class DefaultFallbackStrategy
    implements FallbackStrategy {
        private static final Random EXECUTE_RANDOM = new Random();
        private double yellowRatio = 1.0;
        private double redRatio = 5.0;

        public DefaultFallbackStrategy() {
        }

        public DefaultFallbackStrategy(double yellowRatio, double redRatio) {
            this.yellowRatio = yellowRatio;
            this.redRatio = redRatio;
        }

        @Override
        public boolean check(FallbackInfo info) {
            double errorRatio = (double)info.getErrorTimes() * 1.0 / (double)info.getRequestTimes() * 100.0;
            if (errorRatio > this.redRatio) {
                info.setStatus(FallbackStatus.RED);
            } else if (errorRatio > this.yellowRatio) {
                info.setStatus(FallbackStatus.YELLOW);
            } else {
                info.setStatus(FallbackStatus.GREEN);
            }
            switch (info.getStatus()) {
                case RED: {
                    return EXECUTE_RANDOM.nextInt(info.getRequestTimes() * 100) <= info.getRequestTimes();
                }
                case YELLOW: {
                    return EXECUTE_RANDOM.nextInt(info.getRequestTimes() * 100) <= info.getRequestTimes() * 2;
                }
            }
            return true;
        }
    }

    @FunctionalInterface
    public static interface FallbackStrategy {
        public boolean check(FallbackInfo var1);
    }

    public static class FallbackException
    extends RuntimeException {
        public FallbackException(String message) {
            super(message);
        }
    }

    public static enum FallbackStatus {
        GREEN,
        YELLOW,
        RED;

    }

    public static class FallbackInfo {
        private FallbackStatus status = FallbackStatus.GREEN;
        private LocalDateTime lastGreenTime = LocalDateTime.now();
        private LocalDateTime lastYellowTime = null;
        private LocalDateTime lastRedTime = null;
        private AtomicInteger requestTimes = new AtomicInteger(0);
        private AtomicInteger successTimes = new AtomicInteger(0);
        private AtomicInteger errorTimes = new AtomicInteger(0);

        public void setStatus(FallbackStatus status) {
            this.status = status;
            switch (status) {
                case GREEN: {
                    this.initLastGreenTime();
                    this.initRequestTimes();
                    this.initSuccessTimes();
                    this.initErrorTimes();
                    break;
                }
                case YELLOW: {
                    this.initLastYellowTime();
                    break;
                }
                case RED: {
                    this.initLastRedTime();
                    break;
                }
            }
        }

        void request() {
            this.requestTimes.incrementAndGet();
        }

        void success() {
            this.successTimes.incrementAndGet();
        }

        void error() {
            this.errorTimes.incrementAndGet();
        }

        void initRequestTimes() {
            this.requestTimes = new AtomicInteger(0);
        }

        void initSuccessTimes() {
            this.successTimes = new AtomicInteger(0);
        }

        void initErrorTimes() {
            this.errorTimes = new AtomicInteger(0);
        }

        void initLastGreenTime() {
            this.lastGreenTime = LocalDateTime.now();
        }

        void initLastYellowTime() {
            this.lastYellowTime = LocalDateTime.now();
        }

        void initLastRedTime() {
            this.lastRedTime = LocalDateTime.now();
        }

        public FallbackStatus getStatus() {
            return this.status;
        }

        public int getRequestTimes() {
            return this.requestTimes.intValue();
        }

        public int getSuccessTimes() {
            return this.successTimes.intValue();
        }

        public int getErrorTimes() {
            return this.errorTimes.intValue();
        }

        public LocalDateTime getLastGreenTime() {
            return this.lastGreenTime;
        }

        public LocalDateTime getLastYellowTime() {
            return this.lastYellowTime;
        }

        public LocalDateTime getLastRedTime() {
            return this.lastRedTime;
        }
    }
}

