/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import com.ecfront.dew.common.inner.IdcardUtils;
import java.util.UUID;
import java.util.regex.Pattern;

public class FieldHelper {
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]*[A-Z0-9]+\\.[A-Z]{2,6}$", 2);
    private static final Pattern MOBILE_PATTERN = Pattern.compile("^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4\\D])|(18[0-9])|(166)|(199)|(198))\\d{8}$");
    private static final Pattern CHINESE_PATTERN = Pattern.compile("^[\u4e00-\u9fa5]+$");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");
    private static String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    FieldHelper() {
    }

    public boolean validateEmail(String email) {
        return EMAIL_ADDRESS_PATTERN.matcher(email).matches();
    }

    public boolean validateMobile(String mobile) {
        return MOBILE_PATTERN.matcher(mobile).matches();
    }

    public boolean validateIdNumber(String idNumber) {
        return IdcardUtils.validateCard(idNumber);
    }

    public boolean isIPv4Address(String str) {
        return IPV4_PATTERN.matcher(str).matches();
    }

    public boolean isIPv6Address(String str) {
        return this.isIPv6StdAddress(str) || this.isIPv6HexCompressedAddress(str);
    }

    private boolean isIPv6StdAddress(String str) {
        return IPV6_STD_PATTERN.matcher(str).matches();
    }

    private boolean isIPv6HexCompressedAddress(String str) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(str).matches();
    }

    public boolean isChinese(String str) {
        return CHINESE_PATTERN.matcher(str).matches();
    }

    public int getAgeByIdCard(String idNumber) {
        return IdcardUtils.getAgeByIdCard(idNumber);
    }

    public String getBirthByIdCard(String idNumber) {
        return IdcardUtils.getBirthByIdCard(idNumber);
    }

    public Short getYearByIdCard(String idNumber) {
        return IdcardUtils.getYearByIdCard(idNumber);
    }

    public Short getMonthByIdCard(String idNumber) {
        return IdcardUtils.getMonthByIdCard(idNumber);
    }

    public Short getDateByIdCard(String idNumber) {
        return IdcardUtils.getDateByIdCard(idNumber);
    }

    public String getGenderByIdCard(String idNumber) {
        return IdcardUtils.getGenderByIdCard(idNumber);
    }

    public String getProvinceByIdCard(String idNumber) {
        return IdcardUtils.getProvinceByIdCard(idNumber);
    }

    public String createUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String createShortUUID() {
        StringBuilder shortBuffer = new StringBuilder();
        String uuid = this.createUUID();
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }
}

