/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;

public class FileHelper {
    FileHelper() {
    }

    public String readAllByPathName(String pathName, String encode) throws IOException {
        return new String(Files.readAllBytes(Paths.get(pathName, new String[0])), encode);
    }

    public String readAllByFile(File file, String encode) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), encode);
    }

    public String readAllByPath(Path path, String encode) throws IOException {
        return new String(Files.readAllBytes(path), encode);
    }

    public String readAllByClassPath(String classpath, String encode) throws IOException {
        File file = new File(FileHelper.class.getResource("/").getPath() + classpath);
        if (file.exists()) {
            return this.readAllByFile(file, encode);
        }
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpath);
        BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
        return buffer.lines().collect(Collectors.joining("\n"));
    }
}

