/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import com.ecfront.dew.common.Resp;
import com.ecfront.dew.common.interceptor.DewInterceptContext;
import com.ecfront.dew.common.interceptor.DewInterceptExec;
import com.ecfront.dew.common.interceptor.DewInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorHelper {
    private static Logger logger = LoggerFactory.getLogger(InterceptorHelper.class);
    private static Map<String, List<DewInterceptor<?, ?>>> CONTAINER = new HashMap();

    InterceptorHelper() {
    }

    public void register(String category, DewInterceptor<?, ?> interceptor) {
        if (!CONTAINER.containsKey(category)) {
            CONTAINER.put(category, new ArrayList());
        }
        CONTAINER.get(category).add(interceptor);
    }

    public void register(String category, List<DewInterceptor<?, ?>> interceptors) {
        CONTAINER.put(category, interceptors);
    }

    public <I, O> Resp<DewInterceptContext<I, O>> process(String category, I input, DewInterceptExec<I, O> fun) {
        return this.process(category, input, new HashMap<String, Object>(), fun);
    }

    public <I, O> Resp<DewInterceptContext<I, O>> process(String category, I input, Map<String, Object> args, DewInterceptExec<I, O> fun) {
        DewInterceptContext context = new DewInterceptContext();
        context.setInput(input);
        context.setArgs(args);
        logger.debug("[DewInterceptorProcessor] Process [{}]", (Object)category);
        if (!CONTAINER.containsKey(category)) {
            return fun.exec(context);
        }
        List<DewInterceptor<?, ?>> interceptors = CONTAINER.get(category);
        Resp beforeR = InterceptorHelper.doProcess(context, interceptors, true);
        if (!beforeR.ok()) {
            return beforeR;
        }
        Resp<DewInterceptContext<I, O>> execR = fun.exec(beforeR.getBody());
        if (!execR.ok()) {
            return execR;
        }
        return InterceptorHelper.doProcess(execR.getBody(), interceptors, false);
    }

    private static <I, O> Resp<DewInterceptContext<I, O>> doProcess(DewInterceptContext<I, O> context, List<DewInterceptor<?, ?>> interceptors, boolean isBefore) {
        Resp<DewInterceptContext<Object, Object>> result = Resp.success(context);
        for (DewInterceptor<?, ?> interceptor : interceptors) {
            logger.trace("[DewInterceptorProcessor] Process interceptor [{}]:{}-{}", new Object[]{interceptor.getCategory(), interceptor.getName(), isBefore ? "before" : "after"});
            DewInterceptor<?, ?> interceptorE = interceptor;
            try {
                result = isBefore ? interceptorE.before(context) : interceptorE.after(context);
                if (result.ok()) continue;
                logger.warn("[DewInterceptorProcessor] Process interceptor error [{}]:{}-{},[{}]{}", new Object[]{interceptor.getCategory(), interceptor.getName(), isBefore ? "before" : "after", result.getCode(), result.getMessage()});
                interceptorE.error(context);
                return result;
            }
            catch (Throwable e) {
                result = Resp.serverError(e.getMessage());
                logger.error("[DewInterceptorProcessor] Process interceptor error [{}]:{}-{},[{}]{}", new Object[]{interceptor.getCategory(), interceptor.getName(), isBefore ? "before" : "after", result.getCode(), result.getMessage()});
                interceptorE.error(context);
                return result;
            }
        }
        return result;
    }
}

