/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import com.ecfront.dew.common.DependencyHelper;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class JsonHelper {
    private static final Map<String, JsonHelper> INSTANCES = new HashMap<String, JsonHelper>();
    private ObjectMapper mapper;

    static JsonHelper pick(String instanceId) {
        return INSTANCES.computeIfAbsent(instanceId, k -> new JsonHelper());
    }

    private JsonHelper() {
        if (DependencyHelper.hasDependency("com.fasterxml.jackson.core.JsonProcessingException")) {
            this.mapper = new ObjectMapper();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            JavaTimeModule javaTimeModule = new JavaTimeModule();
            javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ISO_DATE_TIME));
            this.mapper.registerModule((Module)javaTimeModule);
            this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            this.setTimeZone(Calendar.getInstance().getTimeZone());
        }
    }

    public void setTimeZone(TimeZone tz) {
        this.mapper.setTimeZone(tz);
    }

    public String toJsonString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode toJson(Object obj) {
        if (obj instanceof String) {
            try {
                return this.mapper.readTree((String)obj);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mapper.valueToTree(obj);
    }

    public <E> List<E> toList(Object obj, Class<E> clazz) {
        return (List)this.toGeneric(obj, List.class, clazz);
    }

    public <E> Set<E> toSet(Object obj, Class<E> clazz) {
        return (Set)this.toGeneric(obj, Set.class, clazz);
    }

    public <K, V> Map<K, V> toMap(Object obj, Class<K> keyClazz, Class<V> valueClazz) {
        return (Map)this.toGeneric(obj, Map.class, keyClazz, valueClazz);
    }

    public Object toGeneric(Object obj, Class<?> parametrized, Class ... parameterClasses) {
        JavaType type = this.mapper.getTypeFactory().constructParametricType(parametrized, parameterClasses);
        return this.toGeneric(obj, type);
    }

    private Object toGeneric(Object obj, JavaType type) {
        try {
            if (obj instanceof String) {
                return this.mapper.readValue((String)obj, type);
            }
            if (obj instanceof JsonNode) {
                return this.mapper.readValue(obj.toString(), type);
            }
            return this.mapper.readValue(this.mapper.writeValueAsString(obj), type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <E> E toObject(Object obj, Class<E> clazz) {
        try {
            if (obj instanceof String) {
                if (clazz == String.class) {
                    return (E)obj;
                }
                return (E)this.mapper.readValue((String)obj, clazz);
            }
            if (obj instanceof JsonNode) {
                return (E)this.mapper.readValue(obj.toString(), clazz);
            }
            return (E)this.mapper.readValue(this.mapper.writeValueAsString(obj), clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode path(JsonNode jsonNode, String pathStr) {
        String[] splitPaths = pathStr.split("\\.");
        if ((jsonNode = jsonNode.path(splitPaths[0])) instanceof MissingNode) {
            return null;
        }
        if (splitPaths.length == 1) {
            return jsonNode;
        }
        return this.path(jsonNode, pathStr.substring(pathStr.indexOf(".") + 1));
    }

    public ObjectNode createObjectNode() {
        return this.mapper.createObjectNode();
    }

    public ArrayNode createArrayNode() {
        return this.mapper.createArrayNode();
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

