/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Page<E>
implements Serializable {
    private long pageNumber;
    private long pageSize;
    private long pageTotal;
    private long recordTotal;
    private List<E> objects;

    public static <S> Page<S> build(long pageNumber, long pageSize, long recordTotal, List<S> objects) {
        Page dto = new Page();
        dto.pageNumber = pageNumber;
        dto.pageSize = pageSize;
        dto.recordTotal = recordTotal;
        dto.pageTotal = (recordTotal + pageSize - 1L) / pageSize;
        dto.objects = objects;
        return dto;
    }

    public <T> Page<T> convert(Function<E, T> converter) {
        Page<Object> page = new Page<Object>();
        page.setPageNumber(this.getPageNumber());
        page.setPageSize(this.getPageSize());
        page.setPageTotal(this.getPageTotal());
        page.setRecordTotal(this.getRecordTotal());
        if (this.getObjects() != null) {
            page.setObjects(this.getObjects().stream().map(converter).collect(Collectors.toList()));
        } else {
            page.setObjects(null);
        }
        return page;
    }

    public boolean isFirstPage() {
        return this.pageNumber == 1L;
    }

    public boolean isLastPage() {
        return this.pageNumber == this.pageTotal;
    }

    public boolean hasNextPage() {
        return this.pageNumber < this.pageTotal;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public long getPageTotal() {
        return this.pageTotal;
    }

    public void setPageTotal(long pageTotal) {
        this.pageTotal = pageTotal;
    }

    public long getRecordTotal() {
        return this.recordTotal;
    }

    public void setRecordTotal(long recordTotal) {
        this.recordTotal = recordTotal;
    }

    public List<E> getObjects() {
        return this.objects;
    }

    public void setObjects(List<E> objects) {
        this.objects = objects;
    }
}

