/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import com.ecfront.dew.common.$;
import com.ecfront.dew.common.Page;
import com.ecfront.dew.common.StandardCode;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Resp<E>
implements Serializable {
    public static final String FLAG_CODE = "code";
    public static final String FLAG_BODY = "body";
    public static final String FLAG_MESSAGE = "message";
    private String code;
    private String message;
    private E body;

    public Resp() {
    }

    public Resp(String code, String message, E body) {
        this.code = code;
        this.message = message;
        this.body = body;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public E getBody() {
        return this.body;
    }

    public void setBody(E body) {
        this.body = body;
    }

    public boolean ok() {
        return Objects.equals(this.code, StandardCode.SUCCESS.toString());
    }

    public static <E> Resp<E> success(E body) {
        return new Resp<E>(StandardCode.SUCCESS.toString(), "", body);
    }

    public static <E> Resp<E> notFound(String message) {
        return new Resp<Object>(StandardCode.NOT_FOUND.toString(), message, null);
    }

    public static <E> Resp<E> conflict(String message) {
        return new Resp<Object>(StandardCode.CONFLICT.toString(), message, null);
    }

    public static <E> Resp<E> locked(String message) {
        return new Resp<Object>(StandardCode.LOCKED.toString(), message, null);
    }

    public static <E> Resp<E> unsupportedMediaType(String message) {
        return new Resp<Object>(StandardCode.UNSUPPORTED_MEDIA_TYPE.toString(), message, null);
    }

    public static <E> Resp<E> badRequest(String message) {
        return new Resp<Object>(StandardCode.BAD_REQUEST.toString(), message, null);
    }

    public static <E> Resp<E> forbidden(String message) {
        return new Resp<Object>(StandardCode.FORBIDDEN.toString(), message, null);
    }

    public static <E> Resp<E> unAuthorized(String message) {
        return new Resp<Object>(StandardCode.UNAUTHORIZED.toString(), message, null);
    }

    public static <E> Resp<E> serverError(String message) {
        return new Resp<Object>(StandardCode.INTERNAL_SERVER_ERROR.toString(), message, null);
    }

    public static <E> Resp<E> notImplemented(String message) {
        return new Resp<Object>(StandardCode.NOT_IMPLEMENTED.toString(), message, null);
    }

    public static <E> Resp<E> serverUnavailable(String message) {
        return new Resp<Object>(StandardCode.SERVICE_UNAVAILABLE.toString(), message, null);
    }

    public static <E> Resp<E> unknown(String message) {
        return new Resp<Object>(StandardCode.UNKNOWN.toString(), message, null);
    }

    public static <E> Resp<E> customFail(String code, String message) {
        return new Resp<Object>(code, message, null);
    }

    public static <E> Resp<E> error(Resp<?> resp) {
        return new Resp<Object>(resp.getCode(), resp.getMessage(), null);
    }

    public Resp fallback() {
        throw new FallbackException(this);
    }

    public static <E> Resp<E> generic(String resp, Class<E> bodyClazz) {
        return Resp.generic($.json.toObject(resp, Resp.class), bodyClazz);
    }

    public static <E> Resp<E> generic(Resp resp, Class<E> bodyClazz) {
        E body = null;
        if (resp.ok() && resp.getBody() != null) {
            body = $.json.toObject(resp.getBody(), bodyClazz);
        }
        return new Resp<Object>(resp.getCode(), resp.getMessage(), body);
    }

    public static <E> Resp<List<E>> genericList(String resp, Class<E> bodyClazz) {
        return Resp.genericList($.json.toObject(resp, Resp.class), bodyClazz);
    }

    public static <E> Resp<List<E>> genericList(Resp resp, Class<E> bodyClazz) {
        List<E> body = null;
        if (resp.ok() && resp.getBody() != null) {
            body = $.json.toList(resp.getBody(), bodyClazz);
        }
        return new Resp<Object>(resp.getCode(), resp.getMessage(), body);
    }

    public static <E> Resp<Set<E>> genericSet(String resp, Class<E> bodyClazz) {
        return Resp.genericSet($.json.toObject(resp, Resp.class), bodyClazz);
    }

    public static <E> Resp<Set<E>> genericSet(Resp resp, Class<E> bodyClazz) {
        Set<E> body = null;
        if (resp.ok() && resp.getBody() != null) {
            body = $.json.toSet(resp.getBody(), bodyClazz);
        }
        return new Resp<Object>(resp.getCode(), resp.getMessage(), body);
    }

    public static <E> Resp<Page<E>> genericPage(String resp, Class<E> bodyClazz) {
        return Resp.genericPage($.json.toObject(resp, Resp.class), bodyClazz);
    }

    public static <E> Resp<Page<E>> genericPage(Resp resp, Class<E> bodyClazz) {
        Page body = null;
        if (resp.ok() && resp.getBody() != null) {
            body = $.json.toObject(resp.getBody(), Page.class);
            if (body.getObjects() != null) {
                body.setObjects(body.getObjects().stream().map(i -> $.json.toObject(i, bodyClazz)).collect(Collectors.toList()));
            } else {
                body.setObjects(null);
            }
        }
        return new Resp<Object>(resp.getCode(), resp.getMessage(), body);
    }

    public static class FallbackException
    extends RuntimeException {
        public FallbackException(Resp<?> resp) {
            super($.json.toJsonString(resp));
        }
    }
}

