/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.mindrot.jbcrypt.BCrypt;

public class SecurityHelper {
    public Symmetric symmetric = new Symmetric();
    public Asymmetric asymmetric = new Asymmetric();
    public Digest digest = new Digest();

    SecurityHelper() {
    }

    public byte[] decodeBase64ToBytes(String str) {
        return Base64.getDecoder().decode(str);
    }

    public String decodeBase64ToString(String str, String encode) throws UnsupportedEncodingException {
        return new String(Base64.getDecoder().decode(str), encode);
    }

    public String encodeBytesToBase64(byte[] str) throws UnsupportedEncodingException {
        return new String(Base64.getEncoder().encode(str));
    }

    public String encodeStringToBase64(String str, String encode) throws UnsupportedEncodingException {
        return new String(Base64.getEncoder().encode(str.getBytes(encode)), encode);
    }

    public class Asymmetric {
        public Map<String, String> generateKeys(String algorithm, int length) throws NoSuchAlgorithmException, UnsupportedEncodingException {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
            keyPairGenerator.initialize(length);
            final KeyPair keyPair = keyPairGenerator.generateKeyPair();
            return new HashMap<String, String>(){
                {
                    this.put("PublicKey", SecurityHelper.this.encodeBytesToBase64(keyPair.getPublic().getEncoded()));
                    this.put("PrivateKey", SecurityHelper.this.encodeBytesToBase64(keyPair.getPrivate().getEncoded()));
                }
            };
        }

        public PrivateKey getPrivateKey(String key, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
            byte[] privateKey = SecurityHelper.this.decodeBase64ToBytes(key);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKey);
            return KeyFactory.getInstance(algorithm).generatePrivate(spec);
        }

        public PublicKey getPublicKey(String key, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
            byte[] privateKey = SecurityHelper.this.decodeBase64ToBytes(key);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(privateKey);
            return KeyFactory.getInstance(algorithm).generatePublic(spec);
        }

        public byte[] encrypt(byte[] data, Key key, int keyLength, String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, key);
            return this.packageCipher(data, cipher, keyLength / 8 - 11, data.length);
        }

        public byte[] decrypt(byte[] data, Key key, int keyLength, String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, key);
            return this.packageCipher(data, cipher, keyLength / 8, data.length);
        }

        private byte[] packageCipher(byte[] data, Cipher cipher, int maxLength, int inputLength) throws IllegalBlockSizeException, BadPaddingException, IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLength - offSet > 0) {
                byte[] cache = inputLength - offSet > maxLength ? cipher.doFinal(data, offSet, maxLength) : cipher.doFinal(data, offSet, inputLength - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * maxLength;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return decryptedData;
        }

        public byte[] sign(PrivateKey key, byte[] data, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
            Signature signer = Signature.getInstance(algorithm);
            signer.initSign(key);
            signer.update(data);
            return signer.sign();
        }

        public boolean verify(PublicKey key, byte[] data, byte[] signature, String algorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
            Signature verifier = Signature.getInstance(algorithm);
            verifier.initVerify(key);
            verifier.update(data);
            return verifier.verify(signature);
        }
    }

    public class Symmetric {
        public String encrypt(String strSrc, String password, String algorithm) throws GeneralSecurityException {
            if (password == null) {
                throw new RuntimeException(String.format("%s must input password", algorithm));
            }
            KeyGenerator kgen = KeyGenerator.getInstance(algorithm);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(password.getBytes());
            kgen.init(128, secureRandom);
            SecretKeySpec key = new SecretKeySpec(kgen.generateKey().getEncoded(), algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, key);
            try {
                return this.byte2HexStr(cipher.doFinal(strSrc.getBytes("utf-8")));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }

        public String decrypt(String strEncrypted, String password, String algorithm) throws GeneralSecurityException {
            KeyGenerator kgen = KeyGenerator.getInstance(algorithm);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(password.getBytes());
            kgen.init(128, secureRandom);
            SecretKeySpec key = new SecretKeySpec(kgen.generateKey().getEncoded(), algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, key);
            try {
                return new String(cipher.doFinal(this.hexStr2Byte(strEncrypted)), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }

        private String byte2HexStr(byte[] buf) {
            StringBuilder sb = new StringBuilder();
            for (byte aBuf : buf) {
                String hex = Integer.toHexString(aBuf & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex.toUpperCase());
            }
            return sb.toString();
        }

        private byte[] hexStr2Byte(String hexStr) {
            if (hexStr.length() < 1) {
                return null;
            }
            byte[] result = new byte[hexStr.length() / 2];
            for (int i = 0; i < hexStr.length() / 2; ++i) {
                int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
                int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
                result[i] = (byte)(high * 16 + low);
            }
            return result;
        }
    }

    public class Digest {
        public String digest(String strSrc, String algorithm) throws NoSuchAlgorithmException {
            String encryptStr;
            switch (algorithm.toLowerCase()) {
                case "bcrypt": {
                    encryptStr = BCrypt.hashpw((String)strSrc, (String)BCrypt.gensalt());
                    break;
                }
                case "md5": {
                    MessageDigest md5MD = MessageDigest.getInstance(algorithm);
                    md5MD.update(strSrc.getBytes());
                    encryptStr = new BigInteger(1, md5MD.digest()).toString(16);
                    while (encryptStr.length() < 32) {
                        encryptStr = "0" + encryptStr;
                    }
                    break;
                }
                default: {
                    MessageDigest md = MessageDigest.getInstance(algorithm);
                    md.update(strSrc.getBytes());
                    byte[] digest = md.digest();
                    encryptStr = String.format("%064x", new BigInteger(1, digest));
                }
            }
            return encryptStr;
        }

        public boolean validate(String strSrc, String strEncrypted, String algorithm) throws GeneralSecurityException {
            boolean result;
            switch (algorithm.toLowerCase()) {
                case "bcrypt": {
                    result = BCrypt.checkpw((String)strSrc, (String)strEncrypted);
                    break;
                }
                default: {
                    result = Objects.equals(this.digest(strSrc, algorithm), strEncrypted);
                }
            }
            return result;
        }
    }
}

