/*
 * Decompiled with CFR 0.152.
 */
package com.ecfront.dew.common;

import com.ecfront.dew.common.ReportHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellHelper {
    private static final Logger logger = LoggerFactory.getLogger(ShellHelper.class);
    private volatile String taskId;
    private volatile String successFlag;
    private volatile String progressFlag;
    private volatile ReportHandler reportHandler;
    private volatile StringBuffer result = new StringBuffer();
    private boolean returnResult = false;

    ShellHelper() {
    }

    public void execute(String shellPath, String taskId, String successFlag, String progressFlag, boolean returnResult, ReportHandler reportHandler) {
        this.taskId = taskId;
        this.successFlag = successFlag.toLowerCase();
        this.progressFlag = progressFlag.toLowerCase();
        this.returnResult = returnResult;
        this.reportHandler = reportHandler;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shellPath});
            if (process != null) {
                StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
                StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
                Future<Boolean> errorFuture = Executors.newCachedThreadPool().submit(errorGobbler);
                Future<Boolean> outputFuture = Executors.newCachedThreadPool().submit(outputGobbler);
                if (0 == process.waitFor()) {
                    if (errorFuture.get().booleanValue() || outputFuture.get().booleanValue()) {
                        if (reportHandler != null) {
                            reportHandler.complete(taskId, this.result.length() > 0 ? this.result.substring(0, this.result.length() - 2) : this.result.toString());
                        }
                        logger.debug("Execute Success: " + shellPath);
                    } else {
                        logger.warn("Execute fail: Not Find successFlag [" + successFlag + "], shellPath:" + shellPath);
                        reportHandler.fail(taskId, "Not Find successFlag [" + successFlag + "], shellPath:" + shellPath);
                    }
                } else {
                    logger.warn("Execute fail: Abnormal termination , shellPath:" + shellPath);
                    reportHandler.fail(taskId, "Abnormal termination , shellPath:" + shellPath);
                }
            } else {
                logger.warn("Execute fail: PID NOT exist , shellPath:" + shellPath);
                reportHandler.fail(taskId, "PID NOT exist , shellPath:" + shellPath);
            }
        }
        catch (Exception e) {
            logger.error("Execute fail: ", (Throwable)e);
            reportHandler.fail(taskId, e.getMessage() + " , shellPath:" + shellPath);
        }
    }

    private class StreamGobbler
    implements Callable<Boolean> {
        private InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                String line;
                isr = new InputStreamReader(this.is);
                br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    logger.trace("Shell content:" + line);
                    if (ShellHelper.this.returnResult) {
                        ShellHelper.this.result.append(line).append("\r\n");
                    }
                    if (ShellHelper.this.successFlag != null && line.toLowerCase().contains(ShellHelper.this.successFlag)) {
                        ShellHelper.this.reportHandler.success(ShellHelper.this.taskId);
                        Boolean bl = true;
                        return bl;
                    }
                    if (ShellHelper.this.progressFlag == null || !line.toLowerCase().contains(ShellHelper.this.progressFlag)) continue;
                    ShellHelper.this.reportHandler.progress(ShellHelper.this.taskId, Integer.valueOf(line.substring(line.indexOf(ShellHelper.this.progressFlag) + ShellHelper.this.progressFlag.length()).trim()));
                }
            }
            catch (IOException e) {
                logger.warn("Execute fail: ", (Throwable)e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        logger.warn("Execute warn: ", (Throwable)e);
                    }
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (Exception e) {
                        logger.warn("Execute warn: ", (Throwable)e);
                    }
                }
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (Exception e) {
                        logger.warn("Execute warn: ", (Throwable)e);
                    }
                }
            }
            return false;
        }
    }
}

