/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp;

import com.ecwid.mailchimp.MailChimpAPIVersion;
import com.ecwid.mailchimp.MailChimpException;
import com.ecwid.mailchimp.MailChimpMethod;
import com.ecwid.mailchimp.connection.HttpClientConnectionManager;
import com.ecwid.mailchimp.connection.MailChimpConnectionManager;
import com.ecwid.mailchimp.internal.gson.MailChimpGsonFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailChimpClient
implements Closeable {
    private static final Logger log = Logger.getLogger(MailChimpClient.class.getName());
    private final MailChimpConnectionManager connection;

    public MailChimpClient() {
        this(new HttpClientConnectionManager());
    }

    public MailChimpClient(MailChimpConnectionManager connection) {
        this.connection = connection;
    }

    private String execute(String url, String request, MailChimpAPIVersion version) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Post to " + url + " : " + request);
        }
        if (version.compareTo(MailChimpAPIVersion.v2_0) < 0) {
            request = URLEncoder.encode(request, "UTF-8");
        }
        String response = this.connection.post(url, request);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Response: " + response);
        }
        return response;
    }

    private JsonElement execute(String url, JsonElement request, MailChimpAPIVersion version) throws IOException {
        return new JsonParser().parse(this.execute(url, request.toString(), version));
    }

    public <R> R execute(MailChimpMethod<R> method) throws IOException, MailChimpException {
        JsonElement error;
        Gson gson = MailChimpGsonFactory.createGson();
        JsonElement result = this.execute(this.buildUrl(method), gson.toJsonTree(method), method.getMetaInfo().version());
        if (result.isJsonObject() && (error = result.getAsJsonObject().get("error")) != null) {
            JsonElement code = result.getAsJsonObject().get("code");
            throw new MailChimpException(code.getAsInt(), error.getAsString());
        }
        return (R)gson.fromJson(result, method.getResultType());
    }

    private String buildUrl(MailChimpMethod<?> method) throws UnsupportedEncodingException {
        String apikey = method.apikey;
        if (apikey == null) {
            throw new IllegalArgumentException("apikey is not set");
        }
        int dash = apikey.lastIndexOf(45);
        if (dash <= 0) {
            throw new IllegalArgumentException("Wrong apikey: " + apikey);
        }
        String prefix = apikey.substring(dash + 1);
        MailChimpMethod.Method metaInfo = method.getMetaInfo();
        StringBuilder sb = new StringBuilder();
        sb.append("https://");
        sb.append(prefix);
        sb.append(".api.mailchimp.com/");
        sb.append((Object)metaInfo.version()).append("/");
        if (metaInfo.version().compareTo(MailChimpAPIVersion.v2_0) < 0) {
            sb.append("?method=").append(metaInfo.name());
            sb.append("&output=json");
        } else {
            sb.append(metaInfo.name());
            sb.append(".json");
        }
        return sb.toString();
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not close connection", e);
        }
    }
}

