/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp;

import com.ecwid.mailchimp.MailChimpAPIVersion;
import com.ecwid.mailchimp.MailChimpObject;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class MailChimpMethod<R>
extends MailChimpObject {
    private final TypeToken<R> resultTypeToken = new TypeToken<R>(this.getClass()){};
    @MailChimpObject.Field
    public String apikey;

    public final Method getMetaInfo() {
        for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
            Method a = c.getAnnotation(Method.class);
            if (a == null) continue;
            return a;
        }
        throw new IllegalArgumentException("Neither " + this.getClass() + " nor its superclasses are annotated with " + Method.class);
    }

    public final Type getResultType() {
        Type type = this.resultTypeToken.getType();
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType) {
            return type;
        }
        throw new IllegalArgumentException("Cannot resolve result type: " + this.resultTypeToken);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Method {
        public MailChimpAPIVersion version();

        public String name();
    }
}

