/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp;

import com.ecwid.mailchimp.internal.gson.MailChimpGsonFactory;
import com.ecwid.mailchimp.internal.guava.Iterators;
import com.ecwid.mailchimp.internal.guava.Objects;
import com.google.gson.JsonParseException;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MailChimpObject
extends AbstractMap<String, Object>
implements Serializable {
    private static Map<Class<?>, Map<String, java.lang.reflect.Field>> reflectiveMappings = new ConcurrentHashMap();
    private static Map<Class<?>, Map<String, Type>> reflectiveMappingsTypes = new ConcurrentHashMap();
    private final Map<String, java.lang.reflect.Field> reflective = MailChimpObject.getReflectiveMapping(this.getClass());
    private final Map<String, Object> regular = new LinkedHashMap<String, Object>();

    private static Map<String, java.lang.reflect.Field> getReflectiveMapping(Class<? extends MailChimpObject> clazz) {
        Map<String, java.lang.reflect.Field> mapping = reflectiveMappings.get(clazz);
        if (mapping == null) {
            mapping = new LinkedHashMap<String, java.lang.reflect.Field>();
            LinkedList<Class<? extends MailChimpObject>> classes = new LinkedList<Class<? extends MailChimpObject>>();
            Class<? extends MailChimpObject> c = clazz;
            while (MailChimpObject.class.isAssignableFrom(c)) {
                classes.addFirst(c);
                c = c.getSuperclass();
            }
            for (Class clazz2 : classes) {
                for (java.lang.reflect.Field f : clazz2.getDeclaredFields()) {
                    Field annotation = f.getAnnotation(Field.class);
                    if (annotation == null) continue;
                    if (Modifier.isStatic(f.getModifiers())) {
                        throw new IllegalArgumentException("Field must not be static: " + f);
                    }
                    String name = annotation.name();
                    if (name.isEmpty()) {
                        name = f.getName();
                    }
                    if (mapping.put(name, f) != null) {
                        throw new IllegalArgumentException("Ambiguous reflective mapping: " + name);
                    }
                    f.setAccessible(true);
                }
            }
            reflectiveMappings.put(clazz, Collections.unmodifiableMap(mapping));
        }
        return mapping;
    }

    public static Map<String, Type> getReflectiveMappingTypes(Class<? extends MailChimpObject> clazz) {
        Map<String, Type> types = reflectiveMappingsTypes.get(clazz);
        if (types == null) {
            types = new LinkedHashMap<String, Type>();
            for (Map.Entry<String, java.lang.reflect.Field> entry : MailChimpObject.getReflectiveMapping(clazz).entrySet()) {
                types.put(entry.getKey(), entry.getValue().getGenericType());
            }
            reflectiveMappingsTypes.put(clazz, Collections.unmodifiableMap(types));
        }
        return types;
    }

    public Map<String, Type> getReflectiveMappingTypes() {
        return MailChimpObject.getReflectiveMappingTypes(this.getClass());
    }

    @Override
    public Object get(Object key) {
        java.lang.reflect.Field field = this.reflective.get(key);
        if (field != null) {
            return this.get(field);
        }
        return this.regular.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Null keys not allowed");
        }
        java.lang.reflect.Field field = this.reflective.get(key);
        if (field != null) {
            return this.set(field, value);
        }
        return this.regular.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String && this.reflective.containsKey((String)key)) {
            throw new ReflectiveValueRemovalException((String)key);
        }
        return this.regular.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.reflective.containsKey(key) || this.regular.containsKey(key);
    }

    @Override
    public int size() {
        return this.reflective.size() + this.regular.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return Iterators.concat(new ReflectiveKeyIterator(), MailChimpObject.this.regular.keySet().iterator());
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof String && MailChimpObject.this.containsKey((String)o);
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof String && MailChimpObject.this.containsKey((String)o)) {
                    MailChimpObject.this.remove((String)o);
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return MailChimpObject.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return Iterators.concat(new ReflectiveEntryIterator(), MailChimpObject.this.regular.entrySet().iterator());
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Map.Entry) {
                    if (this.contains((Map.Entry)o)) {
                        MailChimpObject.this.remove((String)((Map.Entry)o).getKey());
                        return true;
                    }
                    return false;
                }
                return false;
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry && ((Map.Entry)o).getKey() instanceof String) {
                    String key = (String)((Map.Entry)o).getKey();
                    if (MailChimpObject.this.containsKey(key)) {
                        Object value1 = ((Map.Entry)o).getValue();
                        Object value2 = MailChimpObject.this.get(key);
                        return Objects.equal(value1, value2);
                    }
                    return false;
                }
                return false;
            }

            @Override
            public int size() {
                return MailChimpObject.this.size();
            }
        };
    }

    public final String toJson() {
        return MailChimpGsonFactory.createGson().toJson((Object)this);
    }

    public static <T extends MailChimpObject> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)((MailChimpObject)MailChimpGsonFactory.createGson().fromJson(json, clazz));
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends MailChimpObject> T as(Class<T> clazz) {
        return MailChimpObject.fromJson(this.toJson(), clazz);
    }

    private Object get(java.lang.reflect.Field field) {
        try {
            return field.get(this);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Object set(java.lang.reflect.Field field, Object value) {
        try {
            Object oldValue = field.get(this);
            field.set(this, value);
            return oldValue;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private class ReflectiveEntryIterator
    extends AbstractReflectiveIterator<Map.Entry<String, Object>> {
        private ReflectiveEntryIterator() {
        }

        @Override
        protected Map.Entry<String, Object> reify(Map.Entry<String, java.lang.reflect.Field> entry) {
            return new ReflectiveEntry(entry.getKey(), entry.getValue());
        }
    }

    private class ReflectiveKeyIterator
    extends AbstractReflectiveIterator<String> {
        private ReflectiveKeyIterator() {
        }

        @Override
        protected String reify(Map.Entry<String, java.lang.reflect.Field> entry) {
            return entry.getKey();
        }
    }

    private abstract class AbstractReflectiveIterator<T>
    implements Iterator<T> {
        private final Iterator<Map.Entry<String, java.lang.reflect.Field>> i;
        private Map.Entry<String, java.lang.reflect.Field> lastEntry;

        private AbstractReflectiveIterator() {
            this.i = MailChimpObject.this.reflective.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public T next() {
            this.lastEntry = this.i.next();
            return this.reify(this.lastEntry);
        }

        @Override
        public void remove() {
            throw new ReflectiveValueRemovalException(this.lastEntry.getKey());
        }

        protected abstract T reify(Map.Entry<String, java.lang.reflect.Field> var1);
    }

    private class ReflectiveEntry
    implements Map.Entry<String, Object> {
        final String key;
        final java.lang.reflect.Field field;

        ReflectiveEntry(String key, java.lang.reflect.Field field) {
            this.key = key;
            this.field = field;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return MailChimpObject.this.get(this.field);
        }

        @Override
        public Object setValue(Object value) {
            return MailChimpObject.this.set(this.field, value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getKey(), this.getValue());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                ReflectiveEntry e1 = this;
                Map.Entry e2 = (Map.Entry)obj;
                return Objects.equal(e1.getKey(), e2.getKey()) && Objects.equal(e1.getValue(), e2.getValue());
            }
            return false;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class ReflectiveValueRemovalException
    extends IllegalArgumentException {
        ReflectiveValueRemovalException(String key) {
            super("Cannot remove reflective mapping: " + key + " -> " + MailChimpObject.this.reflective.get(key));
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface Field {
        public String name() default "";
    }
}

