/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp.connection;

import com.ecwid.mailchimp.connection.MailChimpConnectionManager;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpClientConnectionManager
implements MailChimpConnectionManager {
    private static final int DEFAULT_TIMEOUT = 15000;
    private final HttpClient http = new DefaultHttpClient();

    public HttpClientConnectionManager() {
        this(15000, 15000);
    }

    public HttpClientConnectionManager(int connectTimeout, int readTimeout) {
        this.setConnectTimeout(connectTimeout);
        this.setReadTimeout(readTimeout);
    }

    @Override
    public String post(String url, String payload) throws IOException {
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(payload, "UTF-8"));
        HttpResponse response = this.http.execute((HttpUriRequest)post);
        if (response.getEntity() != null) {
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8").trim();
        }
        throw new IOException(response.getStatusLine().toString());
    }

    @Override
    public void close() {
        this.http.getConnectionManager().shutdown();
    }

    public int getConnectTimeout() {
        return HttpConnectionParams.getConnectionTimeout((HttpParams)this.http.getParams());
    }

    public void setConnectTimeout(int connectTimeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.http.getParams(), (int)connectTimeout);
    }

    public int getReadTimeout() {
        return HttpConnectionParams.getSoTimeout((HttpParams)this.http.getParams());
    }

    public void setReadTimeout(int readTimeout) {
        HttpConnectionParams.setSoTimeout((HttpParams)this.http.getParams(), (int)readTimeout);
    }
}

