/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp.connection;

import com.ecwid.mailchimp.connection.MailChimpConnectionManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class JavaNetURLConnectionManager
implements MailChimpConnectionManager {
    private static final int DEFAULT_TIMEOUT = 15000;
    private HttpURLConnection conn = null;
    private int connectTimeout;
    private int readTimeout;

    public JavaNetURLConnectionManager() {
        this(15000, 15000);
    }

    public JavaNetURLConnectionManager(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public String post(String url, String payload) throws IOException {
        int cnt;
        URL mcUrl = new URL(url);
        this.conn = (HttpURLConnection)mcUrl.openConnection();
        this.conn.setDoOutput(true);
        this.conn.setConnectTimeout(this.connectTimeout);
        this.conn.setReadTimeout(this.readTimeout);
        this.conn.setRequestMethod("POST");
        byte[] bytes = payload.getBytes("UTF-8");
        this.conn.addRequestProperty("Content-Type", "application/json; charset=utf-8");
        this.conn.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        this.conn.getOutputStream().write(bytes);
        InputStream is = this.conn.getResponseCode() == 200 ? this.conn.getInputStream() : this.conn.getErrorStream();
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[4096];
        while ((cnt = reader.read(buf)) >= 0) {
            sb.append(buf, 0, cnt);
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

