/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp.internal.gson;

import com.ecwid.mailchimp.internal.gson.MailChimpObjectTypeAdapter;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MailChimpGsonFactory {
    private static final ExclusionStrategy exclusionStrategy = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fa) {
            return true;
        }

        public boolean shouldSkipClass(Class<?> type) {
            return false;
        }
    };

    private MailChimpGsonFactory() {
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setExclusionStrategies(new ExclusionStrategy[]{exclusionStrategy});
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeAdapterFactory(MailChimpObjectTypeAdapter.FACTORY);
        return builder.create();
    }

    private static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        DateTypeAdapter() {
            this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JsonElement serialize(Date t, Type type, JsonSerializationContext jsc) {
            DateFormat dateFormat = this.format;
            synchronized (dateFormat) {
                return new JsonPrimitive(this.format.format(t));
            }
        }

        public Date deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            DateFormat dateFormat = this.format;
            synchronized (dateFormat) {
                try {
                    return !je.getAsString().isEmpty() ? this.format.parse(je.getAsString()) : null;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Cannot deserialize date: " + je);
                }
            }
        }
    }
}

