/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp.internal.guava;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Iterators {
    private Iterators() {
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b) {
        Iterators.checkNotNull(a);
        Iterators.checkNotNull(b);
        return Iterators.concat(Arrays.asList(a, b).iterator());
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b, Iterator<? extends T> c) {
        Iterators.checkNotNull(a);
        Iterators.checkNotNull(b);
        Iterators.checkNotNull(c);
        return Iterators.concat(Arrays.asList(a, b, c).iterator());
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b, Iterator<? extends T> c, Iterator<? extends T> d) {
        Iterators.checkNotNull(a);
        Iterators.checkNotNull(b);
        Iterators.checkNotNull(c);
        Iterators.checkNotNull(d);
        return Iterators.concat(Arrays.asList(a, b, c, d).iterator());
    }

    public static <T> Iterator<T> concat(final Iterator<? extends Iterator<? extends T>> inputs) {
        Iterators.checkNotNull(inputs);
        return new Iterator<T>(){
            Iterator<? extends T> current = Collections.emptyList().iterator();
            Iterator<? extends T> removeFrom;

            @Override
            public boolean hasNext() {
                boolean currentHasNext;
                while (!(currentHasNext = ((Iterator)Iterators.checkNotNull(this.current)).hasNext()) && inputs.hasNext()) {
                    this.current = (Iterator)inputs.next();
                }
                return currentHasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeFrom = this.current;
                return this.current.next();
            }

            @Override
            public void remove() {
                Iterators.checkState(this.removeFrom != null, "no calls to next() since last call to remove()");
                this.removeFrom.remove();
                this.removeFrom = null;
            }
        };
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    private static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }
}

