/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.bean;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.TransactionType;
import java.util.LinkedHashMap;
import java.util.Map;

public enum WxTransactionType implements TransactionType
{
    JSAPI("pay/unifiedorder"){

        @Override
        public void setAttribute(Map<String, Object> parameters, PayOrder order) {
            parameters.put(parameters.containsKey("sub_appid") ? "sub_openid" : "openid", order.getOpenid());
        }
    }
    ,
    NATIVE("pay/unifiedorder"){

        @Override
        public void setAttribute(Map<String, Object> parameters, PayOrder order) {
            parameters.put("product_id", order.getOutTradeNo());
        }

        @Override
        public boolean isReturn() {
            return true;
        }
    }
    ,
    APP("pay/unifiedorder"),
    FACEPAY("pay/facepay"){

        @Override
        public void setAttribute(Map<String, Object> parameters, PayOrder order) {
            parameters.put("openid", order.getOpenid());
            parameters.put("face_code", order.getAuthCode());
        }
    }
    ,
    MWEB("pay/unifiedorder"){

        @Override
        public void setAttribute(Map<String, Object> parameters, PayOrder order) {
            LinkedHashMap<String, String> value = new LinkedHashMap<String, String>(6);
            value.put("type", "Wap");
            value.put("wap_url", order.getWapUrl());
            value.put("wap_name", order.getWapName());
            JSONObject sceneInfo = new JSONObject();
            sceneInfo.put("h5_info", value);
            parameters.put("scene_info", sceneInfo.toJSONString());
        }

        @Override
        public boolean isReturn() {
            return true;
        }
    }
    ,
    MICROPAY("pay/micropay"){

        @Override
        public void setAttribute(Map<String, Object> parameters, PayOrder order) {
            parameters.put("auth_code", order.getAuthCode());
            parameters.remove("notify_url");
            parameters.remove("trade_type");
        }

        @Override
        public boolean isReturn() {
            return true;
        }
    }
    ,
    QUERY("pay/orderquery"),
    CLOSE("pay/closeorder"),
    REVERSE("secapi/pay/reverse"),
    REFUND("secapi/pay/refund"),
    REFUNDQUERY("pay/refundquery"),
    DOWNLOADBILL("pay/downloadbill"),
    GETSIGNKEY("pay/getsignkey");

    private String method;

    private WxTransactionType(String method) {
        this.method = method;
    }

    public String getType() {
        return this.name();
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isReturn() {
        return false;
    }

    public void setAttribute(Map<String, Object> parameters, PayOrder order) {
    }
}

