/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.v3.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.HttpRequestTemplate;
import com.egzosn.pay.common.http.HttpStringEntity;
import com.egzosn.pay.common.http.ResponseEntity;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.sign.SignTextUtils;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.bean.WxPayError;
import com.egzosn.pay.wx.v3.api.WxPayAssistService;
import com.egzosn.pay.wx.v3.api.WxPayConfigStorage;
import com.egzosn.pay.wx.v3.api.WxPayService;
import com.egzosn.pay.wx.v3.bean.WxTransactionType;
import com.egzosn.pay.wx.v3.utils.AntCertificationUtil;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;

public class DefaultWxPayAssistService
implements WxPayAssistService {
    private WxPayConfigStorage payConfigStorage;
    private HttpRequestTemplate requestTemplate;
    private WxPayService wxPayService;

    public DefaultWxPayAssistService(WxPayService wxPayService) {
        this.wxPayService = wxPayService;
        this.payConfigStorage = (WxPayConfigStorage)wxPayService.getPayConfigStorage();
        this.requestTemplate = wxPayService.getHttpRequestTemplate();
    }

    @Override
    public JSONObject doExecute(Map<String, Object> parameters, TransactionType transactionType) {
        String requestBody = JSON.toJSONString(parameters);
        return this.doExecute(requestBody, transactionType, new Object[0]);
    }

    @Override
    public ResponseEntity<JSONObject> doExecuteEntity(String body, TransactionType transactionType, Object ... uriVariables) {
        String reqUrl = UriVariables.getUri((String)this.wxPayService.getReqUrl(transactionType), (Object[])uriVariables);
        MethodType method = MethodType.valueOf((String)transactionType.getMethod());
        if (MethodType.GET == method && StringUtils.isNotEmpty((CharSequence)body)) {
            reqUrl = reqUrl + "?".concat(body);
            body = "";
        }
        HttpEntity entity = this.buildHttpEntity(reqUrl, body, transactionType.getMethod());
        ResponseEntity responseEntity = this.requestTemplate.doExecuteEntity(reqUrl, (Object)entity, JSONObject.class, method);
        return responseEntity;
    }

    @Override
    public JSONObject doExecute(String body, TransactionType transactionType, Object ... uriVariables) {
        ResponseEntity<JSONObject> responseEntity = this.doExecuteEntity(body, transactionType, uriVariables);
        int statusCode = responseEntity.getStatusCode();
        JSONObject responseBody = (JSONObject)responseEntity.getBody();
        if (statusCode >= 400) {
            throw new PayErrorException((PayError)new WxPayError(responseBody.getString("code"), responseBody.getString("message"), responseBody.toJSONString()));
        }
        return responseBody;
    }

    @Override
    public JSONObject doExecute(Map<String, Object> parameters, PayOrder order) {
        TransactionType transactionType = order.getTransactionType();
        return this.doExecute(parameters, transactionType);
    }

    @Override
    public HttpEntity buildHttpEntity(String url, String body, String method) {
        String nonceStr = SignTextUtils.randomStr();
        long timestamp = DateUtils.toEpochSecond();
        String canonicalUrl = UriVariables.getCanonicalUrl((String)url);
        String signText = StringUtils.joining((String)"\n", (String[])new String[]{method, canonicalUrl, String.valueOf(timestamp), nonceStr, body});
        String sign = this.wxPayService.createSign(signText, this.payConfigStorage.getInputCharset());
        String serialNumber = this.payConfigStorage.getCertEnvironment().getSerialNumber();
        String token = String.format("mchid=\"%s\",nonce_str=\"%s\",timestamp=\"%d\",serial_no=\"%s\",signature=\"%s\"", this.payConfigStorage.getMchId(), nonceStr, timestamp, serialNumber, sign);
        HttpStringEntity entity = new HttpStringEntity(body, ContentType.APPLICATION_JSON);
        entity.addHeader((Header)new BasicHeader("Authorization", "WECHATPAY2-SHA256-RSA2048 ".concat(token)));
        entity.addHeader((Header)new BasicHeader("User-Agent", "Pay-Java-Parent"));
        entity.addHeader((Header)new BasicHeader("Accept", ContentType.APPLICATION_JSON.getMimeType()));
        return entity;
    }

    @Override
    public void refreshCertificate() {
        JSONObject responseEntity = this.doExecute("", WxTransactionType.CERT, new Object[0]);
        if (null == responseEntity) {
            throw new PayErrorException((PayError)new WxPayError("failure", "\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25"));
        }
        JSONArray certificates = responseEntity.getJSONArray("data");
        if (null == certificates) {
            return;
        }
        for (int i = 0; i < certificates.size(); ++i) {
            JSONObject certificate = certificates.getJSONObject(i);
            JSONObject encryptCertificate = certificate.getJSONObject("encrypt_certificate");
            String associatedData = encryptCertificate.getString("associated_data");
            String nonce = encryptCertificate.getString("nonce");
            String ciphertext = encryptCertificate.getString("ciphertext");
            String publicKey = AntCertificationUtil.decryptToString(associatedData, nonce, ciphertext, this.payConfigStorage.getV3ApiKey(), this.payConfigStorage.getInputCharset());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(publicKey.getBytes(StandardCharsets.UTF_8));
            AntCertificationUtil.loadCertificate(certificate.getString("serial_no"), inputStream);
        }
    }

    @Override
    public Certificate getCertificate(String serialNo) {
        Certificate certificate = AntCertificationUtil.getCertificate(serialNo);
        if (null == certificate) {
            this.refreshCertificate();
            certificate = AntCertificationUtil.getCertificate(serialNo);
        }
        return certificate;
    }
}

