/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jmx.http.rpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;

final class HttpMBeanServerRpc {
    public static final Charset UTF_8;
    private static final char[] lookup;
    private static final byte[] reverseLookup;

    private HttpMBeanServerRpc() {
    }

    public static byte[] createSuccessResponse(Object result) throws IOException {
        return HttpMBeanServerRpc.serialize(result);
    }

    public static byte[] createExceptionResponse(Exception exception) throws IOException {
        return HttpMBeanServerRpc.serialize(exception);
    }

    public static byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(bytes);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
        return bytes.toByteArray();
    }

    public static Object deserialize(InputStream inputStream) throws IOException {
        try {
            return new ObjectInputStream(inputStream).readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null && declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }

    public static void propagateIfPossible(Throwable throwable) {
        HttpMBeanServerRpc.propagateIfInstanceOf(throwable, Error.class);
        HttpMBeanServerRpc.propagateIfInstanceOf(throwable, RuntimeException.class);
    }

    public static String base64Encode(String data) {
        return HttpMBeanServerRpc.base64Encode(data.getBytes(UTF_8));
    }

    public static String base64Encode(byte[] bytes) {
        int chunk;
        StringBuilder buf = new StringBuilder((bytes.length + 2) / 3 * 4);
        int i = 0;
        int end = bytes.length - 2;
        while (i < end) {
            chunk = (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
            buf.append(lookup[chunk >> 18]);
            buf.append(lookup[chunk >> 12 & 0x3F]);
            buf.append(lookup[chunk >> 6 & 0x3F]);
            buf.append(lookup[chunk & 0x3F]);
        }
        int len = bytes.length;
        if (i < len) {
            chunk = (bytes[i++] & 0xFF) << 16;
            buf.append(lookup[chunk >> 18]);
            if (i < len) {
                buf.append(lookup[(chunk |= (bytes[i] & 0xFF) << 8) >> 12 & 0x3F]);
                buf.append(lookup[chunk >> 6 & 0x3F]);
            } else {
                buf.append(lookup[chunk >> 12 & 0x3F]);
                buf.append('=');
            }
            buf.append('=');
        }
        return buf.toString();
    }

    public static byte[] base64Decode(String encoded) {
        int padding = 0;
        int i = encoded.length() - 1;
        while (encoded.charAt(i) == '=') {
            ++padding;
            --i;
        }
        int length = encoded.length() * 6 / 8 - padding;
        byte[] bytes = new byte[length];
        int index = 0;
        int n = encoded.length();
        for (int i2 = 0; i2 < n; i2 += 4) {
            int word = reverseLookup[encoded.charAt(i2)] << 18;
            word += reverseLookup[encoded.charAt(i2 + 1)] << 12;
            word += reverseLookup[encoded.charAt(i2 + 2)] << 6;
            word += reverseLookup[encoded.charAt(i2 + 3)];
            for (int j = 0; j < 3 && index + j < length; ++j) {
                bytes[index + j] = (byte)(word >> 8 * (2 - j));
            }
            index += 3;
        }
        return bytes;
    }

    static {
        int i;
        UTF_8 = Charset.forName("UTF-8");
        lookup = new char[64];
        reverseLookup = new byte[256];
        for (i = 0; i < 26; ++i) {
            HttpMBeanServerRpc.lookup[i] = (char)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i < 52) {
            HttpMBeanServerRpc.lookup[i] = (char)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i < 62) {
            HttpMBeanServerRpc.lookup[i] = (char)(48 + j);
            ++i;
            ++j;
        }
        HttpMBeanServerRpc.lookup[62] = 43;
        HttpMBeanServerRpc.lookup[63] = 47;
        for (i = 0; i < 256; ++i) {
            HttpMBeanServerRpc.reverseLookup[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            HttpMBeanServerRpc.reverseLookup[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            HttpMBeanServerRpc.reverseLookup[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            HttpMBeanServerRpc.reverseLookup[i] = (byte)(i - 48 + 52);
        }
        HttpMBeanServerRpc.reverseLookup[43] = 62;
        HttpMBeanServerRpc.reverseLookup[47] = 63;
        HttpMBeanServerRpc.reverseLookup[61] = 0;
    }
}

