/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.client;

import com.facebook.drift.client.DriftClientFactory;
import com.facebook.drift.client.ExceptionClassifier;
import com.facebook.drift.client.address.AddressSelector;
import com.facebook.drift.client.stats.MethodInvocationStatsFactory;
import com.facebook.drift.client.stats.NullMethodInvocationStatsFactory;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.transport.client.MethodInvokerFactory;
import java.util.Objects;

public class DriftClientFactoryManager<I> {
    private final ThriftCodecManager codecManager;
    private final MethodInvokerFactory<I> methodInvokerFactory;
    private final MethodInvocationStatsFactory methodInvocationStatsFactory;

    public DriftClientFactoryManager(ThriftCodecManager codecManager, MethodInvokerFactory<I> methodInvokerFactory) {
        this(codecManager, methodInvokerFactory, new NullMethodInvocationStatsFactory());
    }

    public DriftClientFactoryManager(ThriftCodecManager codecManager, MethodInvokerFactory<I> methodInvokerFactory, MethodInvocationStatsFactory methodInvocationStatsFactory) {
        this.codecManager = Objects.requireNonNull(codecManager, "codecManager is null");
        this.methodInvokerFactory = Objects.requireNonNull(methodInvokerFactory, "methodInvokerFactory is null");
        this.methodInvocationStatsFactory = methodInvocationStatsFactory;
    }

    public DriftClientFactory createDriftClientFactory(I clientIdentity, AddressSelector<?> addressSelector, ExceptionClassifier exceptionClassifier) {
        return new DriftClientFactory(this.codecManager, () -> this.methodInvokerFactory.createMethodInvoker(clientIdentity), addressSelector, exceptionClassifier, this.methodInvocationStatsFactory);
    }
}

