/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.slice;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hive.ql.io.slice.Slice;
import org.apache.hadoop.hive.ql.io.slice.SliceOutput;

public class BasicSliceOutput
extends SliceOutput {
    private final Slice slice;
    private int size;

    protected BasicSliceOutput(Slice slice) {
        this.slice = slice;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isWritable() {
        return this.writableBytes() > 0;
    }

    @Override
    public int writableBytes() {
        return this.slice.length() - this.size;
    }

    @Override
    public void writeByte(int value) {
        this.slice.setByte(this.size, value);
        ++this.size;
    }

    @Override
    public void writeShort(int value) {
        this.slice.setShort(this.size, value);
        this.size += 2;
    }

    @Override
    public void writeInt(int value) {
        this.slice.setInt(this.size, value);
        this.size += 4;
    }

    @Override
    public void writeLong(long value) {
        this.slice.setLong(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeDouble(double value) {
        this.slice.setDouble(this.size, value);
        this.size += 8;
    }

    @Override
    public void writeBytes(byte[] source, int sourceIndex, int length) {
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    @Override
    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    @Override
    public void writeBytes(Slice source, int sourceIndex, int length) {
        this.slice.setBytes(this.size, source, sourceIndex, length);
        this.size += length;
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        int writtenBytes = this.slice.setBytes(this.size, in, length);
        if (writtenBytes > 0) {
            this.size += writtenBytes;
        }
        return writtenBytes;
    }

    @Override
    public BasicSliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    @Override
    public SliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.write(source, sourceIndex, length);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    @Override
    public BasicSliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    @Override
    public Slice slice() {
        return this.slice.slice(0, this.size);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("size", this.size).add("capacity", this.slice.length()).toString();
    }
}

