/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.slice;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class SizeOf {
    public static final byte SIZE_OF_BYTE = 1;
    public static final byte SIZE_OF_SHORT = 2;
    public static final byte SIZE_OF_INT = 4;
    public static final byte SIZE_OF_LONG = 8;
    public static final byte SIZE_OF_FLOAT = 4;
    public static final byte SIZE_OF_DOUBLE = 8;
    private static final Unsafe UNSAFE;
    public static final int ARRAY_BOOLEAN_BASE_OFFSET;
    public static final int ARRAY_BOOLEAN_INDEX_SCALE;
    public static final int ARRAY_BYTE_BASE_OFFSET;
    public static final int ARRAY_BYTE_INDEX_SCALE;
    public static final int ARRAY_SHORT_BASE_OFFSET;
    public static final int ARRAY_SHORT_INDEX_SCALE;
    public static final int ARRAY_INT_BASE_OFFSET;
    public static final int ARRAY_INT_INDEX_SCALE;
    public static final int ARRAY_LONG_BASE_OFFSET;
    public static final int ARRAY_LONG_INDEX_SCALE;
    public static final int ARRAY_FLOAT_BASE_OFFSET;
    public static final int ARRAY_FLOAT_INDEX_SCALE;
    public static final int ARRAY_DOUBLE_BASE_OFFSET;
    public static final int ARRAY_DOUBLE_INDEX_SCALE;
    public static final int ARRAY_OBJECT_BASE_OFFSET;
    public static final int ARRAY_OBJECT_INDEX_SCALE;

    public static long sizeOf(boolean[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)ARRAY_BOOLEAN_BASE_OFFSET + (long)ARRAY_BOOLEAN_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(byte[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)ARRAY_BYTE_BASE_OFFSET + (long)ARRAY_BYTE_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(short[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)ARRAY_SHORT_BASE_OFFSET + (long)ARRAY_SHORT_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(int[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)ARRAY_INT_BASE_OFFSET + (long)ARRAY_INT_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(long[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)ARRAY_LONG_BASE_OFFSET + (long)ARRAY_LONG_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(float[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)ARRAY_FLOAT_BASE_OFFSET + (long)ARRAY_FLOAT_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(double[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)ARRAY_DOUBLE_BASE_OFFSET + (long)ARRAY_DOUBLE_INDEX_SCALE * (long)array.length;
    }

    public static long sizeOf(Object[] array) {
        if (array == null) {
            return 0L;
        }
        return (long)ARRAY_OBJECT_BASE_OFFSET + (long)ARRAY_OBJECT_INDEX_SCALE * (long)array.length;
    }

    private SizeOf() {
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            if (UNSAFE == null) {
                throw new RuntimeException("Unsafe access not available");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ARRAY_BOOLEAN_BASE_OFFSET = UNSAFE.arrayBaseOffset(boolean[].class);
        ARRAY_BOOLEAN_INDEX_SCALE = UNSAFE.arrayIndexScale(boolean[].class);
        ARRAY_BYTE_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        ARRAY_BYTE_INDEX_SCALE = UNSAFE.arrayIndexScale(byte[].class);
        ARRAY_SHORT_BASE_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
        ARRAY_SHORT_INDEX_SCALE = UNSAFE.arrayIndexScale(short[].class);
        ARRAY_INT_BASE_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
        ARRAY_INT_INDEX_SCALE = UNSAFE.arrayIndexScale(int[].class);
        ARRAY_LONG_BASE_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
        ARRAY_LONG_INDEX_SCALE = UNSAFE.arrayIndexScale(long[].class);
        ARRAY_FLOAT_BASE_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
        ARRAY_FLOAT_INDEX_SCALE = UNSAFE.arrayIndexScale(float[].class);
        ARRAY_DOUBLE_BASE_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
        ARRAY_DOUBLE_INDEX_SCALE = UNSAFE.arrayIndexScale(double[].class);
        ARRAY_OBJECT_BASE_OFFSET = UNSAFE.arrayBaseOffset(Object[].class);
        ARRAY_OBJECT_INDEX_SCALE = UNSAFE.arrayIndexScale(Object[].class);
    }
}

