/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.IntArrayBlockBuilder;
import com.facebook.presto.common.block.UncheckedBlock;
import com.facebook.presto.common.type.AbstractPrimitiveType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.TypeSignature;
import io.airlift.slice.Slice;

public abstract class AbstractIntType
extends AbstractPrimitiveType
implements FixedWidthType {
    protected AbstractIntType(TypeSignature signature) {
        super(signature, Long.TYPE);
    }

    @Override
    public final int getFixedSize() {
        return 4;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public final long getLong(Block block, int position) {
        return block.getInt(position);
    }

    @Override
    public final long getLongUnchecked(UncheckedBlock block, int internalPosition) {
        return block.getIntUnchecked(internalPosition);
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeInt((int)value).closeEntry();
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeInt(block.getInt(position)).closeEntry();
        }
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int rightValue;
        int leftValue = leftBlock.getInt(leftPosition);
        return leftValue == (rightValue = rightBlock.getInt(rightPosition));
    }

    @Override
    public long hash(Block block, int position) {
        return AbstractIntType.hash(block.getInt(position));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int leftValue = leftBlock.getInt(leftPosition);
        int rightValue = rightBlock.getInt(rightPosition);
        return Integer.compare(leftValue, rightValue);
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new IntArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 4));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 4);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new IntArrayBlockBuilder(null, positionCount);
    }

    public static long hash(int value) {
        return Long.rotateLeft((long)value * -4417276706812531889L, 31) * -7046029288634856825L;
    }
}

