/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.type;

import com.facebook.presto.common.type.BigintEnumType;
import com.facebook.presto.common.type.ParameterKind;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeParameter;
import java.util.List;

public final class BigintEnumParametricType
implements ParametricType {
    public static final BigintEnumParametricType BIGINT_ENUM = new BigintEnumParametricType();

    private BigintEnumParametricType() {
    }

    @Override
    public String getName() {
        return "BigintEnum";
    }

    @Override
    public Type createType(List<TypeParameter> parameters) {
        BigintEnumParametricType.checkArgument(parameters.size() == 1, "Enum type expects exactly one parameter, got %s", parameters);
        BigintEnumParametricType.checkArgument(parameters.get(0).getKind() == ParameterKind.LONG_ENUM, "Enum definition expected, got %s", parameters);
        return new BigintEnumType(parameters.get(0).getLongEnumMap());
    }

    private static void checkArgument(boolean argument, String format, Object ... args) {
        if (!argument) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }
}

