/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zzh.lib.views.utils.DimenUtil;
import java.util.ArrayList;
import java.util.List;

public class WaterMarkDrawable
extends Drawable {
    private Paint paint = new Paint();
    private List<String> labels;
    private Context context;
    private int degree = 30;
    private int fontSize = 14;
    private int lines = 15;
    private String textColor = "#989898";
    private int textIntColor = Color.parseColor((String)"#989898");

    public List<String> getLabels() {
        if (this.labels == null) {
            return new ArrayList<String>();
        }
        return this.labels;
    }

    public int getLines() {
        return this.lines;
    }

    public WaterMarkDrawable setLines(int lines) {
        if (lines > 0) {
            this.lines = lines;
        }
        return this;
    }

    public WaterMarkDrawable setLabels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public int getDegree() {
        return this.degree;
    }

    public WaterMarkDrawable setDegree(int degree) {
        this.degree = degree;
        return this;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public WaterMarkDrawable setFontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public String getTextColor() {
        return this.textColor == null ? "#989898" : this.textColor;
    }

    public WaterMarkDrawable setTextColor(String textColor) {
        this.textColor = textColor;
        return this;
    }

    public int getTextIntColor() {
        if (this.textIntColor == 0) {
            this.textIntColor = Color.parseColor((String)this.getTextColor());
            return this.textIntColor;
        }
        return this.textIntColor;
    }

    public WaterMarkDrawable setTextIntColor(int textIntColor) {
        this.textIntColor = textIntColor;
        return this;
    }

    public WaterMarkDrawable(Context context) {
        this.context = context;
    }

    public WaterMarkDrawable(Context context, List<String> labels, int degree, int fontSize) {
        this.labels = labels;
        this.context = context;
        this.degree = degree;
        this.fontSize = fontSize;
    }

    public void draw(@NonNull Canvas canvas) {
        if (!this.getLabels().isEmpty()) {
            int width = this.getBounds().right;
            int height = this.getBounds().bottom;
            canvas.drawColor(0);
            this.paint.setColor(this.getTextIntColor());
            this.paint.setAlpha(40);
            this.paint.setAntiAlias(true);
            this.paint.setTextSize((float)DimenUtil.sp2px(this.context, this.fontSize));
            canvas.save();
            canvas.rotate((float)this.degree);
            float textWidth = this.paint.measureText(this.labels.get(0));
            int index = 0;
            for (int positionY = height / this.lines; positionY <= height; positionY += height / this.lines + 50) {
                float fromX;
                for (float positionX = fromX = (float)(-width) + (float)(index++ % 2) * textWidth; positionX < (float)width; positionX += textWidth * 2.0f) {
                    int spacing = 0;
                    for (String label : this.labels) {
                        canvas.drawText(label, positionX, (float)(positionY + spacing), this.paint);
                        spacing += this.lines;
                    }
                }
            }
            canvas.restore();
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return 0;
    }
}

