/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.zzh.lib.views.R;

public class ExpandTextView
extends AppCompatTextView {
    private static final int TRIM_MODE_LINES = 0;
    private static final int TRIM_MODE_LENGTH = 1;
    private static final int DEFAULT_TRIM_LENGTH = 240;
    private static final int DEFAULT_TRIM_LINES = 2;
    private static final int INVALID_END_INDEX = -1;
    private static final boolean DEFAULT_SHOW_TRIM_EXPANDED_TEXT = true;
    private static final String ELLIPSIZE = "... ";
    private CharSequence text;
    private TextView.BufferType bufferType;
    private boolean readMore = true;
    private int trimLength;
    private CharSequence trimCollapsedText;
    private CharSequence trimExpandedText;
    private final ReadMoreClickableSpan viewMoreSpan;
    private final NormalClickableSpan viewNormalSpan;
    private int colorClickableText;
    private final boolean showTrimExpandedText;
    private int trimMode;
    private int lineEndIndex;
    private int trimLines;
    private View.OnClickListener mOnClickListener;

    public ExpandTextView(Context context) {
        this(context, null);
    }

    public ExpandTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ExpandTextView);
        this.trimLength = typedArray.getInt(R.styleable.ExpandTextView_trimLength, 240);
        int resourceIdTrimCollapsedText = typedArray.getResourceId(R.styleable.ExpandTextView_trimCollapsedText, R.string.zh_expand_more_text);
        int resourceIdTrimExpandedText = typedArray.getResourceId(R.styleable.ExpandTextView_trimExpandedText, R.string.zh_expand_less_text);
        this.trimCollapsedText = this.getResources().getString(resourceIdTrimCollapsedText);
        this.trimExpandedText = this.getResources().getString(resourceIdTrimExpandedText);
        this.trimLines = typedArray.getInt(R.styleable.ExpandTextView_trimLines, 2);
        this.colorClickableText = typedArray.getColor(R.styleable.ExpandTextView_colorClickableText, Color.parseColor((String)"#ff0000"));
        this.showTrimExpandedText = typedArray.getBoolean(R.styleable.ExpandTextView_showTrimExpandedText, true);
        this.trimMode = typedArray.getInt(R.styleable.ExpandTextView_trimMode, 0);
        typedArray.recycle();
        this.viewMoreSpan = new ReadMoreClickableSpan();
        this.viewNormalSpan = new NormalClickableSpan();
        this.onGlobalLayoutLineEndIndex();
        this.setText();
    }

    private void setText() {
        super.setText(this.getDisplayableText(), this.bufferType);
        this.setMovementMethod(LinkMovementMethod.getInstance());
        this.setHighlightColor(0);
    }

    private CharSequence getDisplayableText() {
        return this.getTrimmedText(this.text);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.text = text;
        this.bufferType = type;
        this.setText();
    }

    private CharSequence getTrimmedText(CharSequence text) {
        if (this.trimMode == 1 && text != null && text.length() > this.trimLength) {
            if (this.readMore) {
                return this.updateCollapsedText();
            }
            return this.updateExpandedText();
        }
        if (this.trimMode == 0 && text != null && this.lineEndIndex > 0) {
            if (this.readMore) {
                if (this.getLayout().getLineCount() > this.trimLines) {
                    return this.updateCollapsedText();
                }
            } else {
                return this.updateExpandedText();
            }
        }
        return this.addNormalClickableSpan(new SpannableStringBuilder(text), text);
    }

    private CharSequence updateCollapsedText() {
        int trimEndIndex = this.text.length();
        switch (this.trimMode) {
            case 0: {
                trimEndIndex = this.lineEndIndex - (ELLIPSIZE.length() + this.trimCollapsedText.length() + 1);
                if (trimEndIndex >= 0) break;
                trimEndIndex = this.trimLength + 1;
                break;
            }
            case 1: {
                trimEndIndex = this.trimLength + 1;
            }
        }
        SpannableStringBuilder s = new SpannableStringBuilder(this.text, 0, trimEndIndex).append((CharSequence)ELLIPSIZE).append(this.trimCollapsedText);
        s.setSpan((Object)this.viewNormalSpan, 0, trimEndIndex, 33);
        return this.addClickableSpan(s, this.trimCollapsedText);
    }

    private CharSequence updateExpandedText() {
        if (this.showTrimExpandedText) {
            SpannableStringBuilder s = new SpannableStringBuilder(this.text, 0, this.text.length()).append(this.trimExpandedText);
            return this.addClickableSpan(s, this.trimExpandedText);
        }
        return this.text;
    }

    private CharSequence addClickableSpan(SpannableStringBuilder s, CharSequence trimText) {
        s.setSpan((Object)this.viewNormalSpan, 0, s.length() - trimText.length(), 33);
        s.setSpan((Object)this.viewMoreSpan, s.length() - trimText.length(), s.length(), 33);
        return s;
    }

    private CharSequence addNormalClickableSpan(SpannableStringBuilder s, CharSequence trimText) {
        s.setSpan((Object)this.viewNormalSpan, s.length() - trimText.length(), s.length(), 33);
        return s;
    }

    public void setTrimLength(int trimLength) {
        this.trimLength = trimLength;
        this.setText();
    }

    public void setColorClickableText(int colorClickableText) {
        this.colorClickableText = colorClickableText;
    }

    public void setTrimCollapsedText(CharSequence trimCollapsedText) {
        this.trimCollapsedText = trimCollapsedText;
    }

    public void setTrimExpandedText(CharSequence trimExpandedText) {
        this.trimExpandedText = trimExpandedText;
    }

    public void setTrimMode(int trimMode) {
        this.trimMode = trimMode;
    }

    public void setTrimLines(int trimLines) {
        this.trimLines = trimLines;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.mOnClickListener = l;
    }

    private void onGlobalLayoutLineEndIndex() {
        if (this.trimMode == 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    ViewTreeObserver obs = ExpandTextView.this.getViewTreeObserver();
                    obs.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    ExpandTextView.this.refreshLineEndIndex();
                    ExpandTextView.this.setText();
                }
            });
        }
    }

    private void refreshLineEndIndex() {
        try {
            this.lineEndIndex = this.trimLines == 0 ? this.getLayout().getLineEnd(0) : (this.trimLines > 0 && this.getLineCount() >= this.trimLines ? this.getLayout().getLineEnd(this.trimLines - 1) : -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class NormalClickableSpan
    extends ClickableSpan {
        private NormalClickableSpan() {
        }

        public void onClick(View widget) {
            if (ExpandTextView.this.mOnClickListener != null) {
                ExpandTextView.this.mOnClickListener.onClick(widget);
            }
        }

        public void updateDrawState(@NonNull TextPaint ds) {
            ds.setColor(ExpandTextView.this.getCurrentTextColor());
            ds.setUnderlineText(false);
        }
    }

    private class ReadMoreClickableSpan
    extends ClickableSpan {
        private ReadMoreClickableSpan() {
        }

        public void onClick(View widget) {
            ExpandTextView.this.readMore = !ExpandTextView.this.readMore;
            ExpandTextView.this.setText();
        }

        public void updateDrawState(TextPaint ds) {
            ds.setColor(ExpandTextView.this.colorClickableText);
        }
    }
}

